/*
 * Decompiled with CFR 0.152.
 */
package com.sun.jini.tool;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.PrintWriter;
import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.net.URL;
import java.net.URLClassLoader;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.Iterator;
import java.util.MissingResourceException;
import java.util.ResourceBundle;
import java.util.StringTokenizer;
import java.util.TreeSet;
import java.util.jar.JarEntry;
import java.util.jar.JarFile;
import java.util.jar.JarInputStream;
import java.util.jar.JarOutputStream;
import java.util.jar.Manifest;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class PreferredListGen {
    private final Collection seen = new HashSet();
    private Boolean TRUE;
    private Boolean FALSE;
    private final Collection proxies;
    private final Collection tells;
    private File targetJar;
    private boolean replaceJar;
    private boolean printResults;
    private final Collection jarList;
    private String classpath;
    private final Graph listGraph;
    private boolean forceDefault;
    private boolean defaultToForce;
    private ClassLoader loader;
    private static ResourceBundle resources;
    private static boolean resinit;
    private HashSet jarEntries;
    private HashSet jarFiles;
    private boolean keepNonPublicRoots;
    private boolean doMerge;

    private static String getString(String key, Object v1, Object v2, Object v3) {
        String fmt = "no text found: \"" + key + "\"";
        if (!resinit) {
            try {
                resinit = true;
                resources = ResourceBundle.getBundle("com.sun.jini.tool.resources.preflistgen");
            }
            catch (MissingResourceException e) {
                e.printStackTrace();
            }
        }
        if (resources != null) {
            try {
                fmt = resources.getString(key);
            }
            catch (MissingResourceException e) {
                // empty catch block
            }
        }
        return MessageFormat.format(fmt, v1, v2, v3);
    }

    private static String getString(String key) {
        return PreferredListGen.getString(key, null, null, null);
    }

    private static String getString(String key, Object v1) {
        return PreferredListGen.getString(key, v1, null, null);
    }

    private static String getString(String key, Object v1, Object v2) {
        return PreferredListGen.getString(key, v1, v2, null);
    }

    private static void print(String key, Object v1) {
        System.err.println(PreferredListGen.getString(key, v1));
    }

    private static void print(String key, Object v1, Object v2) {
        System.err.println(PreferredListGen.getString(key, v1, v2));
    }

    private static void print(String key, Object v1, Object v2, Object v3) {
        System.err.println(PreferredListGen.getString(key, v1, v2, v3));
    }

    private PreferredListGen(String[] args) {
        this.seen.add("int");
        this.seen.add("long");
        this.seen.add("float");
        this.seen.add("double");
        this.seen.add("short");
        this.seen.add("void");
        this.seen.add("char");
        this.seen.add("byte");
        this.seen.add("boolean");
        this.TRUE = new Boolean(true);
        this.FALSE = new Boolean(false);
        this.proxies = new HashSet();
        this.tells = new HashSet();
        this.replaceJar = true;
        this.printResults = false;
        this.jarList = new ArrayList();
        this.listGraph = new Graph();
        this.forceDefault = false;
        this.defaultToForce = false;
        this.loader = this.getClass().getClassLoader();
        this.jarEntries = new HashSet();
        this.jarFiles = new HashSet();
        this.keepNonPublicRoots = false;
        this.doMerge = true;
        if (args.length == 0) {
            throw new IllegalArgumentException(PreferredListGen.getString("preflistgen.noargs"));
        }
        for (int i = 0; i < args.length; ++i) {
            String arg = args[i];
            if (arg.equals("-print")) {
                this.setPrint(true);
                continue;
            }
            if (arg.equals("-noreplace")) {
                this.setReplaceJar(false);
                this.setPrint(true);
                continue;
            }
            if (arg.equals("-jar")) {
                this.addJar(args[++i]);
                continue;
            }
            if (arg.equals("-tell")) {
                this.addTell(args[++i]);
                continue;
            }
            if (arg.equals("-impl")) {
                this.addImpl(args[++i]);
                continue;
            }
            if (arg.equals("-api")) {
                this.addApi(args[++i]);
                continue;
            }
            if (arg.equals("-nonpublic")) {
                this.setKeepNonPublicRoots(true);
                continue;
            }
            if (arg.equals("-nomerge")) {
                this.setMerge(false);
                continue;
            }
            if (arg.equals("-default")) {
                String def;
                if ((def = args[++i]).equalsIgnoreCase("true") || def.equalsIgnoreCase("false")) {
                    this.setDefault(def.equalsIgnoreCase("true"));
                    continue;
                }
                String msg = PreferredListGen.getString("preflistgen.baddefault", def);
                throw new IllegalArgumentException(msg);
            }
            if (arg.equals("-cp")) {
                this.setClasspath(args[++i]);
                continue;
            }
            if (arg.equals("-proxy")) {
                this.addProxy(args[++i]);
                continue;
            }
            String msg = PreferredListGen.getString("preflistgen.badoption", arg);
            throw new IllegalArgumentException(msg);
        }
    }

    public PreferredListGen() {
        this.seen.add("int");
        this.seen.add("long");
        this.seen.add("float");
        this.seen.add("double");
        this.seen.add("short");
        this.seen.add("void");
        this.seen.add("char");
        this.seen.add("byte");
        this.seen.add("boolean");
        this.TRUE = new Boolean(true);
        this.FALSE = new Boolean(false);
        this.proxies = new HashSet();
        this.tells = new HashSet();
        this.replaceJar = true;
        this.printResults = false;
        this.jarList = new ArrayList();
        this.listGraph = new Graph();
        this.forceDefault = false;
        this.defaultToForce = false;
        this.loader = this.getClass().getClassLoader();
        this.jarEntries = new HashSet();
        this.jarFiles = new HashSet();
        this.keepNonPublicRoots = false;
        this.doMerge = true;
    }

    public void setPrint(boolean printResults) {
        this.printResults = printResults;
    }

    public void setKeepNonPublicRoots(boolean keepNonPublicRoots) {
        this.keepNonPublicRoots = keepNonPublicRoots;
    }

    public void setMerge(boolean doMerge) {
        this.doMerge = doMerge;
    }

    public void setReplaceJar(boolean replaceJar) {
        this.replaceJar = replaceJar;
    }

    public void addJar(String jarName) {
        this.jarList.add(jarName);
    }

    public void addTell(String tellName) {
        String tellClass = this.fileToClass(tellName);
        this.tells.add(tellClass);
    }

    public void addImpl(String implName) {
        this.listGraph.initialize(implName, true, null);
    }

    public void addApi(String apiName) {
        this.listGraph.initialize(apiName, false, null);
    }

    public void setDefault(boolean def) {
        this.forceDefault = true;
        this.defaultToForce = def;
    }

    public void setClasspath(String path) {
        this.classpath = path;
    }

    public void addProxy(String proxy) {
        this.proxies.add(proxy);
    }

    private void loadJars() throws IOException {
        for (String jarName : this.jarList) {
            File jarFile = new File(jarName);
            this.loadJar(jarFile);
        }
    }

    private void loadJar(File jar) throws IOException {
        if (this.jarFiles.contains(jar)) {
            return;
        }
        this.jarFiles.add(jar);
        if (!jar.exists()) {
            String msg = PreferredListGen.getString("preflistgen.nojarfound", jar);
            throw new IllegalArgumentException(msg);
        }
        if (jar.isDirectory()) {
            String msg = PreferredListGen.getString("preflistgen.jarisdir", jar);
            throw new IllegalArgumentException(msg);
        }
        if (this.targetJar == null) {
            this.targetJar = jar;
            this.populateGraph(this.listGraph, jar);
        } else if (this.doMerge && this.noPreferredList(jar)) {
            this.populateGraph(this.listGraph, jar);
        } else {
            Graph g = this.createGraph(jar);
            this.populateGraph(g, jar);
            this.listGraph.merge(g);
        }
    }

    private boolean noPreferredList(File jar) throws IOException {
        JarFile jarFile = new JarFile(jar);
        return jarFile.getJarEntry("META-INF/PREFERRED.LIST") == null;
    }

    private void populateGraph(Graph g, File jar) {
        try {
            JarFile jarFile = new JarFile(jar);
            Enumeration<JarEntry> en = jarFile.entries();
            while (en.hasMoreElements()) {
                JarEntry entry = en.nextElement();
                String id = entry.getName();
                if (id.startsWith("META-INF") || id.endsWith("/")) continue;
                this.jarEntries.add(id);
                if (id.endsWith(".class")) {
                    g.add(this.fileToClass(id), 4, jar);
                    continue;
                }
                g.add(this.fileToClass(id), 5, jar);
            }
            Manifest manifest = jarFile.getManifest();
            if (manifest == null) {
                return;
            }
            String classPath = manifest.getMainAttributes().getValue("Class-Path");
            if (classPath != null) {
                StringTokenizer tok = new StringTokenizer(classPath);
                while (tok.hasMoreTokens()) {
                    String fileName = tok.nextToken();
                    File nextJar = new File(jar.getParentFile(), fileName);
                    this.loadJar(nextJar);
                }
            }
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    private Graph createGraph(File jarFile) throws IOException {
        Pattern headerPattern = Pattern.compile("^PreferredResources-Version:\\s*(.*?)$");
        Pattern versionPattern = Pattern.compile("^1\\.\\d+$");
        Pattern namePattern = Pattern.compile("^Name:\\s*(.*)$");
        Pattern preferredPattern = Pattern.compile("^Preferred:\\s*(.*)$");
        Graph graph = new Graph();
        JarFile jar = new JarFile(jarFile);
        JarEntry ent = jar.getJarEntry("META-INF/PREFERRED.LIST");
        if (ent == null) {
            graph.setDefaultPref(false);
            return graph;
        }
        BufferedReader r = new BufferedReader(new InputStreamReader(jar.getInputStream(ent), "UTF8"));
        String s = r.readLine();
        if (s == null) {
            throw new IOException("missing preferred list header");
        }
        Matcher m = headerPattern.matcher(s = s.trim());
        if (!m.matches()) {
            throw new IOException("illegal preferred list header: " + s);
        }
        s = m.group(1);
        if (!versionPattern.matcher(s).matches()) {
            throw new IOException("unsupported preferred list version: " + s);
        }
        s = PreferredListGen.nextNonBlankLine(r);
        if (s == null) {
            throw new IOException("empty preferred list");
        }
        m = preferredPattern.matcher(s);
        if (m.matches()) {
            graph.setDefaultPref(Boolean.valueOf(m.group(1)));
            s = PreferredListGen.nextNonBlankLine(r);
        } else {
            graph.setDefaultPref(false);
        }
        while (s != null) {
            m = namePattern.matcher(s);
            if (!m.matches()) {
                throw new IOException("expected preferred entry name: " + s);
            }
            String name = m.group(1);
            s = PreferredListGen.nextNonBlankLine(r);
            if (s == null) {
                throw new IOException("EOF before preferred entry");
            }
            m = preferredPattern.matcher(s);
            if (!m.matches()) {
                throw new IOException("expected preferred entry: " + s);
            }
            boolean pref = Boolean.valueOf(m.group(1));
            graph.initialize(name, pref, jarFile);
            s = PreferredListGen.nextNonBlankLine(r);
        }
        return graph;
    }

    private static String nextNonBlankLine(BufferedReader reader) throws IOException {
        String s;
        while ((s = reader.readLine()) != null) {
            if ((s = s.trim()).length() <= 0 || s.charAt(0) == '#') continue;
            return s;
        }
        return null;
    }

    private String fileToClass(String classID) {
        if ((classID = classID.replace('/', '.')).endsWith(".class")) {
            classID = classID.substring(0, classID.length() - 6);
        }
        return classID;
    }

    private void process(String from, Class c) {
        while (c.isArray()) {
            c = c.getComponentType();
        }
        this.process(from, c.getName());
    }

    private void process(String from, Class[] arr) {
        int i = arr.length;
        while (--i >= 0) {
            this.process(from, arr[i]);
        }
    }

    private boolean include(int modifiers) {
        return (modifiers & 5) != 0;
    }

    private void process(String from, Constructor c) {
        if (!this.include(c.getModifiers())) {
            return;
        }
        this.process(from, c.getParameterTypes());
        this.process(from, c.getExceptionTypes());
    }

    private void process(String from, Method m) {
        if (!this.include(m.getModifiers())) {
            return;
        }
        this.process(from, m.getReturnType());
        this.process(from, m.getParameterTypes());
        this.process(from, m.getExceptionTypes());
    }

    private void process(String from, Field f) {
        if (!this.include(f.getModifiers())) {
            return;
        }
        this.process(from, f.getType());
    }

    private void process(String from, String clazz) {
        if (!this.seen.contains(clazz)) {
            this.seen.add(clazz);
            if (!this.listGraph.contains(clazz)) {
                return;
            }
            Iterator it = this.tells.iterator();
            while (it.hasNext()) {
                if (!clazz.equals((String)it.next())) continue;
                if (from != null) {
                    System.err.println(clazz + " caused by " + from);
                    continue;
                }
                System.err.println(clazz + " is a root class");
            }
            if (!this.listGraph.setPreferred(clazz, false, false)) {
                return;
            }
            this.inspectClass(clazz);
        }
    }

    private void inspectClass(String className) {
        Class<?> c;
        try {
            c = Class.forName(className, false, this.loader);
        }
        catch (Exception e) {
            e.printStackTrace();
            return;
        }
        Class<?> sup = c.getSuperclass();
        if (sup != null) {
            this.process(className, sup);
        }
        Class<?>[] ifaces = c.getInterfaces();
        int i = ifaces.length;
        while (--i >= 0) {
            this.process(className, ifaces[i]);
        }
        Constructor<?>[] cons = c.getDeclaredConstructors();
        int i2 = cons.length;
        while (--i2 >= 0) {
            this.process(className, cons[i2]);
        }
        Method[] methods = c.getDeclaredMethods();
        int i3 = methods.length;
        while (--i3 >= 0) {
            this.process(className, methods[i3]);
        }
        Field[] fields = c.getDeclaredFields();
        int i4 = fields.length;
        while (--i4 >= 0) {
            this.process(className, fields[i4]);
        }
    }

    public void compute() throws IOException {
        if (this.jarList.size() == 0) {
            throw new IllegalArgumentException(PreferredListGen.getString("preflistgen.nojars"));
        }
        ArrayList<URL> list = new ArrayList<URL>();
        if (this.classpath != null) {
            StringTokenizer st = new StringTokenizer(this.classpath, File.pathSeparator);
            while (st.hasMoreTokens()) {
                String fileName = st.nextToken();
                File cpFile = new File(fileName);
                if (!cpFile.exists()) {
                    String msg = PreferredListGen.getString("preflistgen.badcp", fileName);
                    throw new IllegalArgumentException(msg);
                }
                list.add(cpFile.getCanonicalFile().toURI().toURL());
            }
        }
        for (String fileName : this.jarList) {
            list.add(new File(fileName).getCanonicalFile().toURI().toURL());
        }
        if (list.size() > 0) {
            URL[] urls = list.toArray(new URL[list.size()]);
            ClassLoader cl = ClassLoader.getSystemClassLoader();
            if (cl != null) {
                cl = cl.getParent();
            }
            this.loader = new URLClassLoader(urls, cl);
        }
        this.loadJars();
        Collection roots = this.getRoots();
        Iterator it = roots.iterator();
        while (it.hasNext()) {
            String clazz = (String)it.next();
            Class<?> c = null;
            try {
                c = Class.forName(clazz, false, this.loader);
            }
            catch (ClassNotFoundException e) {
                throw new IllegalStateException("could not load root class " + clazz);
            }
            if ((c.getModifiers() & 1) == 0) {
                if (this.keepNonPublicRoots) {
                    PreferredListGen.print("preflistgen.rootNotPublic", c);
                } else if (!this.listGraph.isFrozen(clazz)) {
                    it.remove();
                    this.listGraph.setPreferred(clazz, true, true);
                    continue;
                }
            }
            this.process(null, clazz);
        }
    }

    private Collection getRoots() {
        HashSet roots = new HashSet();
        this.listGraph.addRoots(roots);
        for (String proxy : this.proxies) {
            try {
                Class<?> proxyClass = Class.forName(proxy, false, this.loader);
                this.addProxyRoot(proxyClass, roots);
            }
            catch (ClassNotFoundException e) {
                String msg = PreferredListGen.getString("preflistgen.badproxyclass", proxy);
                IllegalArgumentException iae = new IllegalArgumentException(msg);
                iae.initCause(e);
                throw iae;
            }
        }
        return roots;
    }

    private void addProxyRoot(Class proxyClass, Collection roots) {
        Class<?>[] interfaces = proxyClass.getInterfaces();
        for (int j = 0; j < interfaces.length; ++j) {
            this.addIfPublic(interfaces[j], roots);
        }
        Class superClass = proxyClass.getSuperclass();
        if (superClass != null) {
            this.addProxyRoot(superClass, roots);
        }
    }

    private void addIfPublic(Class intFace, Collection roots) {
        if ((intFace.getModifiers() & 1) != 0) {
            roots.add(intFace.getName());
            return;
        }
        Class<?>[] parents = intFace.getInterfaces();
        for (int i = 0; i < parents.length; ++i) {
            this.addIfPublic(parents[i], roots);
        }
    }

    private static void usage() {
        PreferredListGen.print("preflistgen.usage", null);
    }

    public void generatePreferredList(PrintWriter writer) throws IOException {
        boolean pref;
        if (writer == null && this.printResults) {
            writer = new PrintWriter(System.out);
        }
        String newLine = System.getProperty("line.separator");
        if (!this.tells.isEmpty()) {
            return;
        }
        StringBuffer sb = new StringBuffer();
        sb.append("PreferredResources-Version: 1.0");
        sb.append(newLine);
        TreeSet entries = new TreeSet();
        this.listGraph.markStaleInnerClasses();
        this.listGraph.deleteStaleNodes();
        if (this.forceDefault) {
            pref = this.defaultToForce;
            this.listGraph.setDefaultPref(pref);
            this.listGraph.addEntries(entries);
        } else {
            HashSet bestEntries = new HashSet();
            pref = false;
            this.listGraph.setDefaultPref(pref);
            this.listGraph.addEntries(bestEntries);
            HashSet test = new HashSet();
            this.listGraph.setDefaultPref(true);
            this.listGraph.addEntries(test);
            if (test.size() < bestEntries.size()) {
                bestEntries = test;
                pref = true;
            }
            entries = new TreeSet(bestEntries);
        }
        if (pref || this.forceDefault || entries.isEmpty()) {
            sb.append(newLine);
            sb.append("Preferred: ");
            sb.append(pref);
            sb.append(newLine);
        }
        for (PrefData entry : entries) {
            sb.append(newLine);
            sb.append("Name: ");
            sb.append(entry.name);
            sb.append(newLine);
            sb.append("Preferred: ");
            sb.append(entry.preferred);
            sb.append(newLine);
        }
        String preferredList = sb.toString();
        if (writer != null) {
            writer.print(preferredList);
            writer.flush();
        }
        if (this.replaceJar) {
            this.buildJarFile(preferredList);
        }
    }

    private void buildJarFile(String preferredList) throws IOException {
        int size;
        File newJar = File.createTempFile("pref", "jar");
        newJar.deleteOnExit();
        JarInputStream ji = new JarInputStream(new FileInputStream(this.targetJar));
        JarOutputStream jo = new JarOutputStream(new FileOutputStream(newJar));
        JarEntry entry = new JarEntry("META-INF/");
        jo.putNextEntry(entry);
        jo.closeEntry();
        entry = new JarEntry("META-INF/MANIFEST.MF");
        jo.putNextEntry(entry);
        ji.getManifest().write(jo);
        jo.closeEntry();
        entry = new JarEntry("META-INF/PREFERRED.LIST");
        jo.putNextEntry(entry);
        byte[] ba = preferredList.getBytes();
        jo.write(ba, 0, ba.length);
        while ((entry = ji.getNextJarEntry()) != null) {
            int size2;
            if (entry.getName().equals("META-INF/PREFERRED.LIST")) {
                ji.closeEntry();
                continue;
            }
            jo.putNextEntry(entry);
            ba = new byte[1000];
            while ((size2 = ji.read(ba, 0, 1000)) >= 0) {
                jo.write(ba, 0, size2);
            }
            jo.closeEntry();
        }
        ji.close();
        jo.close();
        FileInputStream fi = new FileInputStream(newJar);
        FileOutputStream fo = new FileOutputStream(this.targetJar);
        ba = new byte[1000];
        while ((size = fi.read(ba)) >= 0) {
            fo.write(ba, 0, size);
        }
        fi.close();
        fo.close();
    }

    public static void main(String[] args) {
        try {
            PreferredListGen dep = new PreferredListGen(args);
            dep.compute();
            dep.generatePreferredList(null);
            System.exit(0);
        }
        catch (IllegalArgumentException e) {
            PreferredListGen.print("preflistgen.badarg", e.getMessage());
            PreferredListGen.usage();
        }
        catch (IOException e) {
            PreferredListGen.print("preflistgen.ioproblem", e.getMessage());
            e.printStackTrace();
        }
        System.exit(1);
    }

    static {
        resinit = false;
    }

    private class Graph {
        static final int INHERIT = 0;
        static final int PKG = 1;
        static final int NAMESPACE = 2;
        static final int DEFAULT = 3;
        static final int CLASS = 4;
        static final int RESOURCE = 5;
        static final int STALE = 6;
        String name;
        HashSet nodes = new HashSet();
        boolean preferred = true;
        Graph parent;
        int type = 0;
        Boolean impliedPref = null;
        File sourceJar = null;

        Graph() {
            this.name = "";
            this.impliedPref = PreferredListGen.this.TRUE;
            this.type = 3;
        }

        Graph(Graph parent, String name, int type, File sourceJar) {
            if (type != 4 && type != 5) {
                throw new IllegalStateException("type must be CLASS or RESOURCE");
            }
            this.parent = parent;
            this.sourceJar = sourceJar;
            int firstDot = name.indexOf(".");
            if (firstDot < 0) {
                Graph outer;
                this.name = name;
                this.type = type;
                this.preferred = parent.childPref();
                if (type == 4 && (outer = this.getOuter()) != null) {
                    this.preferred = outer.preferred;
                }
            } else {
                this.name = name.substring(0, firstDot);
                this.nodes.add(new Graph(this, name.substring(firstDot + 1), type, sourceJar));
            }
        }

        Graph(Graph parent, String name, int type, boolean preferred, File sourceJar) {
            if (type == 0) {
                throw new IllegalStateException("Cannot create a preference node of type INHERIT");
            }
            this.parent = parent;
            this.sourceJar = sourceJar;
            int firstDot = name.indexOf(".");
            if (firstDot < 0) {
                this.name = name;
                this.type = type;
                if (type == 4 || type == 5) {
                    this.preferred = preferred;
                } else {
                    this.impliedPref = new Boolean(preferred);
                }
            } else {
                this.name = name.substring(0, firstDot);
                String childName = name.substring(firstDot + 1);
                this.nodes.add(new Graph(this, childName, type, preferred, sourceJar));
            }
        }

        void initialize(String arg, boolean preferred, File sourceJar) {
            if (this.name.length() > 0) {
                throw new IllegalStateException("must initialize only the root");
            }
            if (arg.endsWith("/-")) {
                String pkgName = PreferredListGen.this.fileToClass(arg.substring(0, arg.length() - 2));
                this.addWithPreference(pkgName, 2, preferred, sourceJar);
            } else if (arg.endsWith("/*")) {
                String pkgName = PreferredListGen.this.fileToClass(arg.substring(0, arg.length() - 2));
                this.addWithPreference(pkgName, 1, preferred, sourceJar);
            } else if (arg.endsWith("/")) {
                String pkgName = PreferredListGen.this.fileToClass(arg.substring(0, arg.length() - 1));
                this.addWithPreference(pkgName, 1, preferred, sourceJar);
            } else if (arg.endsWith(".class")) {
                String leafName = PreferredListGen.this.fileToClass(arg);
                this.addWithPreference(leafName, 4, preferred, sourceJar);
            } else if (arg.indexOf(47) != -1) {
                String leafName = PreferredListGen.this.fileToClass(arg);
                this.addWithPreference(leafName, 5, preferred, sourceJar);
            } else if (arg.indexOf(46) != -1) {
                this.addWithPreference(arg, 4, preferred, sourceJar);
            } else {
                String msg = PreferredListGen.getString("preflistgen.badapi", arg);
                throw new IllegalArgumentException(msg);
            }
        }

        void addRoots(Collection roots) {
            if (this.type == 4 && this.sourceJar == null) {
                String entryName = this.getFullName() + ".class";
                if (!PreferredListGen.this.jarEntries.contains(entryName)) {
                    System.err.println("Class entry " + entryName + " identified by the -" + (this.preferred ? "impl" : "api") + " option does not exist in any JAR file. " + "That entry has been discarded");
                    return;
                }
            }
            if (!(this.type != 4 || this.preferred || this.sourceJar != null && this.sourceJar != PreferredListGen.this.targetJar)) {
                roots.add(PreferredListGen.this.fileToClass(this.getFullName()));
            } else {
                for (Graph g : this.nodes) {
                    g.addRoots(roots);
                }
            }
        }

        void reset() {
            if (this.type != 4 && this.type != 5) {
                this.type = 0;
                this.impliedPref = null;
                for (Graph g : this.nodes) {
                    g.reset();
                }
            }
        }

        boolean impliedChildPref() {
            if (this.type == 2 || this.type == 3) {
                if (this.impliedPref == null) {
                    throw new IllegalStateException("impliedPref is null");
                }
                return this.impliedPref;
            }
            if (this.parent == null) {
                throw new IllegalStateException("default undefined in graph");
            }
            return this.parent.impliedChildPref();
        }

        boolean childPref() {
            if (this.type == 2 || this.type == 3 || this.type == 1) {
                if (this.impliedPref == null) {
                    throw new IllegalStateException("impliedPref is null");
                }
                return this.impliedPref;
            }
            if (this.parent == null) {
                throw new IllegalStateException("default undefined in graph");
            }
            return this.parent.impliedChildPref();
        }

        void setDefaultPref(boolean value) {
            if (this.name.length() > 0) {
                throw new IllegalStateException("must set default on root");
            }
            this.type = 3;
            this.impliedPref = new Boolean(value);
        }

        public String toString() {
            return "Graph[" + this.name + ", Parent = " + this.parent + "]";
        }

        void add(String name, int type, File sourceJar) {
            String nodeName;
            if (type != 4 && type != 5) {
                throw new IllegalStateException("type must be CLASS or RESOURCE");
            }
            if (name == null) {
                return;
            }
            String childName = null;
            int firstDot = name.indexOf(".");
            if (firstDot < 0) {
                nodeName = name;
            } else {
                nodeName = name.substring(0, firstDot);
                childName = name.substring(firstDot + 1);
            }
            for (Graph g : this.nodes) {
                if (!g.name.equals(nodeName)) continue;
                g.add(childName, type, sourceJar);
                return;
            }
            this.nodes.add(new Graph(this, name, type, sourceJar));
        }

        boolean contains(String name) {
            String nodeName;
            String childName = null;
            int firstDot = name.indexOf(".");
            if (firstDot < 0) {
                nodeName = name;
            } else {
                nodeName = name.substring(0, firstDot);
                childName = name.substring(firstDot + 1);
            }
            for (Graph g : this.nodes) {
                if (!g.name.equals(nodeName)) continue;
                if (childName == null) {
                    return true;
                }
                return g.contains(childName);
            }
            return false;
        }

        boolean isFrozen(String name) {
            String nodeName;
            String childName = null;
            int firstDot = name.indexOf(".");
            if (firstDot < 0) {
                nodeName = name;
            } else {
                nodeName = name.substring(0, firstDot);
                childName = name.substring(firstDot + 1);
            }
            for (Graph g : this.nodes) {
                if (!g.name.equals(nodeName)) continue;
                if (childName == null) {
                    if (g.type != 4) {
                        throw new IllegalStateException("Not a class: " + g.getFullName());
                    }
                    return g.sourceJar == null;
                }
                return g.isFrozen(childName);
            }
            return false;
        }

        void addWithPreference(String name, int type, boolean preferred, File sourceJar) {
            String nodeName;
            if (type == 0) {
                throw new IllegalStateException("Cannot add preference node of type INHERIT");
            }
            if (name == null) {
                if (this.sourceJar != null) {
                    this.type = type;
                    if (type == 4 || type == 5) {
                        if (this.preferred != preferred && this.sourceJar != PreferredListGen.this.targetJar) {
                            PreferredListGen.print("preflistgen.prefconflict", this.getFullName(), this.sourceJar, sourceJar);
                            this.preferred = false;
                        } else {
                            this.preferred = preferred;
                        }
                    } else {
                        this.impliedPref = new Boolean(preferred);
                    }
                }
                return;
            }
            String childName = null;
            int firstDot = name.indexOf(".");
            if (firstDot < 0) {
                nodeName = name;
            } else {
                nodeName = name.substring(0, firstDot);
                childName = name.substring(firstDot + 1);
            }
            for (Graph g : this.nodes) {
                if (!g.name.equals(nodeName)) continue;
                g.addWithPreference(childName, type, preferred, sourceJar);
                return;
            }
            this.nodes.add(new Graph(this, name, type, preferred, sourceJar));
        }

        boolean setPreferred(String name, boolean value, boolean force) {
            if (name == null) {
                if (this.type != 4 && this.type != 5) {
                    throw new IllegalStateException("only leaf node preferred state may be set");
                }
                if (this.sourceJar != null || force) {
                    this.preferred = value;
                }
                return this.preferred == value;
            }
            String childName = name;
            String targetName = null;
            int firstDot = name.indexOf(".");
            if (firstDot >= 0) {
                childName = name.substring(0, firstDot);
                targetName = name.substring(firstDot + 1);
            }
            for (Graph g : this.nodes) {
                if (!g.name.equals(childName)) continue;
                return g.setPreferred(targetName, value, force);
            }
            return true;
        }

        int countPreferred(boolean value) {
            if (this.type == 4 || this.type == 5) {
                return value == this.preferred ? 1 : 0;
            }
            int total = 0;
            for (Graph g : this.nodes) {
                total += g.countPreferred(value);
            }
            return total;
        }

        int countImpliedFailures() {
            if (this.type == 4 || this.type == 5) {
                Graph outer;
                if (this.type == 4 && (outer = this.getOuter()) != null) {
                    return outer.preferred == this.preferred ? 0 : 1;
                }
                return this.parent.childPref() != this.preferred ? 1 : 0;
            }
            int total = 0;
            for (Graph g : this.nodes) {
                total += g.countImpliedFailures();
            }
            return total;
        }

        int countLeafNodes() {
            int total = 0;
            for (Graph g : this.nodes) {
                if (g.type == 4 || g.type == 5) {
                    ++total;
                    continue;
                }
                total += g.countLeafNodes();
            }
            return total;
        }

        String getFullName() {
            if (this.name.length() == 0) {
                return "";
            }
            String prefix = "";
            if (this.parent != null) {
                prefix = this.parent.getFullName();
            }
            if (prefix.length() > 0) {
                prefix = prefix + "/";
            }
            return prefix + this.name;
        }

        void markStaleInnerClasses() {
            if (this.type == 4) {
                Graph outer = this.getOuter();
                if (outer != null) {
                    if (outer.preferred == this.preferred) {
                        this.type = 6;
                    } else {
                        PreferredListGen.print("preflistgen.innerwarn", outer.name, this.name);
                    }
                }
            } else {
                for (Graph g : this.nodes) {
                    g.markStaleInnerClasses();
                }
            }
        }

        Graph getOuter() {
            if (this.type != 4) {
                throw new IllegalStateException("Attempt to get outer of a non-class");
            }
            Graph g = null;
            int lastDollar = this.name.lastIndexOf(36);
            if (lastDollar > 0) {
                String outerName = this.name.substring(0, lastDollar);
                g = this.parent.getChild(outerName);
            }
            return g;
        }

        void deleteStaleNodes() {
            Iterator it = this.nodes.iterator();
            while (it.hasNext()) {
                Graph g = (Graph)it.next();
                if (g.type == 6) {
                    it.remove();
                    continue;
                }
                g.deleteStaleNodes();
            }
        }

        Graph getChild(String name) {
            for (Graph g : this.nodes) {
                if (!g.name.equals(name)) continue;
                return g;
            }
            return null;
        }

        boolean containsLeavesOnly() {
            for (Graph g : this.nodes) {
                if (g.type == 4 || g.type == 5) continue;
                return false;
            }
            return true;
        }

        void addLeaves(Collection leaves) {
            if (this.type == 4) {
                leaves.add(new PrefData(this.getFullName() + ".class", this.preferred, this.sourceJar));
                return;
            }
            if (this.type == 5) {
                leaves.add(new PrefData(this.getFullName(), this.preferred, this.sourceJar));
                return;
            }
            for (Graph g : this.nodes) {
                g.addLeaves(leaves);
            }
        }

        void merge(Graph g) {
            HashSet leaves = new HashSet();
            g.addLeaves(leaves);
            for (PrefData data : leaves) {
                int type = data.name.endsWith(".class") ? 4 : 5;
                this.addWithPreference(PreferredListGen.this.fileToClass(data.name), type, data.preferred, data.sourceJar);
            }
        }

        void addEntries(Collection entries) {
            if (this.parent == null) {
                for (Graph g : this.nodes) {
                    g.addEntries(entries);
                }
                return;
            }
            this.reset();
            if (this.countImpliedFailures() == 0) {
                return;
            }
            if (this.type == 4) {
                entries.add(new PrefData(this.getFullName() + ".class", this.preferred));
                return;
            }
            if (this.type == 5) {
                entries.add(new PrefData(this.getFullName(), this.preferred));
                return;
            }
            if (this.nodes.size() == 1) {
                Iterator it = this.nodes.iterator();
                if (!it.hasNext()) {
                    throw new IllegalStateException("Inconsistent iterator");
                }
                Graph g = (Graph)it.next();
                if (g.type != 4 && g.type != 5) {
                    g.addEntries(entries);
                    return;
                }
            }
            boolean gotMatch = false;
            boolean matchValue = false;
            int leafCount = this.countLeafNodes();
            if (leafCount == this.countPreferred(true)) {
                gotMatch = true;
                matchValue = true;
            } else if (leafCount == this.countPreferred(false)) {
                gotMatch = true;
                matchValue = false;
            }
            if (gotMatch) {
                if (this.containsLeavesOnly()) {
                    entries.add(new PrefData(this.getFullName() + "/*", matchValue));
                } else {
                    entries.add(new PrefData(this.getFullName() + "/-", matchValue));
                }
                return;
            }
            int lowestValue = this.countEntries(0, null);
            int bestType = 0;
            Boolean bestImpliedPref = null;
            int count = this.countEntries(1, PreferredListGen.this.TRUE);
            if (count < lowestValue) {
                lowestValue = count;
                bestType = 1;
                bestImpliedPref = PreferredListGen.this.TRUE;
            }
            if ((count = this.countEntries(1, PreferredListGen.this.FALSE)) < lowestValue) {
                lowestValue = count;
                bestType = 1;
                bestImpliedPref = PreferredListGen.this.FALSE;
            }
            if ((count = this.countEntries(2, PreferredListGen.this.TRUE)) < lowestValue) {
                lowestValue = count;
                bestType = 2;
                bestImpliedPref = PreferredListGen.this.TRUE;
            }
            if ((count = this.countEntries(2, PreferredListGen.this.FALSE)) < lowestValue) {
                lowestValue = count;
                bestType = 2;
                bestImpliedPref = PreferredListGen.this.FALSE;
            }
            this.type = bestType;
            this.impliedPref = bestImpliedPref;
            if (this.type == 2) {
                entries.add(new PrefData(this.getFullName() + "/-", this.impliedPref));
            }
            if (this.type == 1) {
                entries.add(new PrefData(this.getFullName() + "/*", this.impliedPref));
            }
            for (Graph g : this.nodes) {
                g.addEntries(entries);
            }
        }

        int countEntries(int type, Boolean pref) {
            HashSet test = new HashSet();
            this.type = type;
            this.impliedPref = pref;
            for (Graph g : this.nodes) {
                g.addEntries(test);
            }
            return test.size();
        }
    }

    private class PrefData
    implements Comparable {
        String name;
        boolean preferred;
        File sourceJar;

        PrefData(String name, boolean preferred) {
            this.name = name;
            this.preferred = preferred;
        }

        PrefData(String name, boolean preferred, File sourceJar) {
            this(name, preferred);
            this.sourceJar = sourceJar;
        }

        public int compareTo(Object o) {
            String oPrefixed = ((PrefData)o).prefixedString();
            return this.prefixedString().compareTo(oPrefixed);
        }

        private String prefixedString() {
            if (this.name.endsWith(".class")) {
                return "a" + this.name;
            }
            if (this.name.endsWith("/*")) {
                return "b" + this.name;
            }
            return "c" + this.name;
        }
    }
}

