/*
 * Decompiled with CFR 0.152.
 */
package com.sun.jini.tool.classdepend;

import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.objectweb.asm.AnnotationVisitor;
import org.objectweb.asm.ClassVisitor;
import org.objectweb.asm.FieldVisitor;
import org.objectweb.asm.Handle;
import org.objectweb.asm.Label;
import org.objectweb.asm.MethodVisitor;
import org.objectweb.asm.Type;
import org.objectweb.asm.TypePath;
import org.objectweb.asm.signature.SignatureReader;
import org.objectweb.asm.signature.SignatureVisitor;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractDependencyVisitor
extends ClassVisitor {
    Set<String> packages = new HashSet<String>();
    Map<String, Map<String, Integer>> groups = new HashMap<String, Map<String, Integer>>();
    Map<String, Integer> current;

    public Map<String, Map<String, Integer>> getGlobals() {
        return this.groups;
    }

    public Set<String> getPackages() {
        return this.packages;
    }

    public AbstractDependencyVisitor() {
        super(327680);
    }

    protected abstract void addName(String var1);

    public void visit(int version, int access, String name, String signature, String superName, String[] interfaces) {
        String p = this.getGroupKey(name);
        this.current = this.groups.get(p);
        if (this.current == null) {
            this.current = new HashMap<String, Integer>();
            this.groups.put(p, this.current);
        }
        if (signature == null) {
            if (superName != null) {
                this.addInternalName(superName);
            }
            this.addInternalNames(interfaces);
        } else {
            this.addSignature(signature);
        }
    }

    public void visitInnerClass(String name, String outerName, String innerName, int access) {
        this.addInternalName(outerName);
        this.addInternalName(name);
    }

    public AnnotationVisitor visitAnnotation(String desc, boolean visible) {
        this.addDesc(desc);
        return new AnnotationDependencyVisitor();
    }

    public AnnotationVisitor visitTypeAnnotation(int typeRef, TypePath typePath, String desc, boolean visible) {
        this.addDesc(desc);
        return new AnnotationDependencyVisitor();
    }

    public FieldVisitor visitField(int access, String name, String desc, String signature, Object value) {
        if (signature == null) {
            this.addDesc(desc);
        } else {
            this.addTypeSignature(signature);
        }
        if (value instanceof Type) {
            this.addType((Type)value);
        }
        return new FieldDependencyVisitor();
    }

    public MethodVisitor visitMethod(int access, String name, String desc, String signature, String[] exceptions) {
        if (signature == null) {
            this.addMethodDesc(desc);
        } else {
            this.addSignature(signature);
        }
        this.addInternalNames(exceptions);
        return new MethodDependencyVisitor();
    }

    private String getGroupKey(String name) {
        int n = name.lastIndexOf(47);
        if (n > -1) {
            name = name.substring(0, n);
        }
        this.packages.add(name);
        return name;
    }

    void addInternalName(String name) {
        if (name != null) {
            this.addType(Type.getObjectType((String)name));
        }
    }

    private void addInternalNames(String[] names) {
        for (int i = 0; names != null && i < names.length; ++i) {
            this.addInternalName(names[i]);
        }
    }

    void addDesc(String desc) {
        this.addType(Type.getType((String)desc));
    }

    void addMethodDesc(String desc) {
        this.addType(Type.getReturnType((String)desc));
        Type[] types = Type.getArgumentTypes((String)desc);
        for (int i = 0; i < types.length; ++i) {
            this.addType(types[i]);
        }
    }

    void addType(Type t) {
        switch (t.getSort()) {
            case 9: {
                this.addType(t.getElementType());
                break;
            }
            case 10: {
                this.addName(t.getInternalName());
                break;
            }
            case 11: {
                this.addMethodDesc(t.getDescriptor());
            }
        }
    }

    private void addSignature(String signature) {
        if (signature != null) {
            new SignatureReader(signature).accept((SignatureVisitor)new SignatureDependencyVisitor());
        }
    }

    void addTypeSignature(String signature) {
        if (signature != null) {
            new SignatureReader(signature).acceptType((SignatureVisitor)new SignatureDependencyVisitor());
        }
    }

    void addConstant(Object cst) {
        if (cst instanceof Type) {
            this.addType((Type)cst);
        } else if (cst instanceof Handle) {
            Handle h = (Handle)cst;
            this.addInternalName(h.getOwner());
            this.addMethodDesc(h.getDesc());
        }
    }

    class SignatureDependencyVisitor
    extends SignatureVisitor {
        String signatureClassName;

        public SignatureDependencyVisitor() {
            super(327680);
        }

        public void visitClassType(String name) {
            this.signatureClassName = name;
            AbstractDependencyVisitor.this.addInternalName(name);
        }

        public void visitInnerClassType(String name) {
            this.signatureClassName = this.signatureClassName + "$" + name;
            AbstractDependencyVisitor.this.addInternalName(this.signatureClassName);
        }
    }

    class MethodDependencyVisitor
    extends MethodVisitor {
        public MethodDependencyVisitor() {
            super(327680);
        }

        public AnnotationVisitor visitAnnotationDefault() {
            return new AnnotationDependencyVisitor();
        }

        public AnnotationVisitor visitAnnotation(String desc, boolean visible) {
            AbstractDependencyVisitor.this.addDesc(desc);
            return new AnnotationDependencyVisitor();
        }

        public AnnotationVisitor visitTypeAnnotation(int typeRef, TypePath typePath, String desc, boolean visible) {
            AbstractDependencyVisitor.this.addDesc(desc);
            return new AnnotationDependencyVisitor();
        }

        public AnnotationVisitor visitParameterAnnotation(int parameter, String desc, boolean visible) {
            AbstractDependencyVisitor.this.addDesc(desc);
            return new AnnotationDependencyVisitor();
        }

        public void visitTypeInsn(int opcode, String type) {
            AbstractDependencyVisitor.this.addType(Type.getObjectType((String)type));
        }

        public void visitFieldInsn(int opcode, String owner, String name, String desc) {
            AbstractDependencyVisitor.this.addInternalName(owner);
            AbstractDependencyVisitor.this.addDesc(desc);
        }

        public void visitMethodInsn(int opcode, String owner, String name, String desc, boolean itf) {
            AbstractDependencyVisitor.this.addInternalName(owner);
            AbstractDependencyVisitor.this.addMethodDesc(desc);
        }

        public void visitInvokeDynamicInsn(String name, String desc, Handle bsm, Object ... bsmArgs) {
            AbstractDependencyVisitor.this.addMethodDesc(desc);
            AbstractDependencyVisitor.this.addConstant(bsm);
            for (int i = 0; i < bsmArgs.length; ++i) {
                AbstractDependencyVisitor.this.addConstant(bsmArgs[i]);
            }
        }

        public void visitLdcInsn(Object cst) {
            AbstractDependencyVisitor.this.addConstant(cst);
        }

        public void visitMultiANewArrayInsn(String desc, int dims) {
            AbstractDependencyVisitor.this.addDesc(desc);
        }

        public AnnotationVisitor visitInsnAnnotation(int typeRef, TypePath typePath, String desc, boolean visible) {
            AbstractDependencyVisitor.this.addDesc(desc);
            return new AnnotationDependencyVisitor();
        }

        public void visitLocalVariable(String name, String desc, String signature, Label start, Label end, int index) {
            AbstractDependencyVisitor.this.addTypeSignature(signature);
        }

        public AnnotationVisitor visitLocalVariableAnnotation(int typeRef, TypePath typePath, Label[] start, Label[] end, int[] index, String desc, boolean visible) {
            AbstractDependencyVisitor.this.addDesc(desc);
            return new AnnotationDependencyVisitor();
        }

        public void visitTryCatchBlock(Label start, Label end, Label handler, String type) {
            if (type != null) {
                AbstractDependencyVisitor.this.addInternalName(type);
            }
        }

        public AnnotationVisitor visitTryCatchAnnotation(int typeRef, TypePath typePath, String desc, boolean visible) {
            AbstractDependencyVisitor.this.addDesc(desc);
            return new AnnotationDependencyVisitor();
        }
    }

    class FieldDependencyVisitor
    extends FieldVisitor {
        public FieldDependencyVisitor() {
            super(327680);
        }

        public AnnotationVisitor visitAnnotation(String desc, boolean visible) {
            AbstractDependencyVisitor.this.addDesc(desc);
            return new AnnotationDependencyVisitor();
        }

        public AnnotationVisitor visitTypeAnnotation(int typeRef, TypePath typePath, String desc, boolean visible) {
            AbstractDependencyVisitor.this.addDesc(desc);
            return new AnnotationDependencyVisitor();
        }
    }

    class AnnotationDependencyVisitor
    extends AnnotationVisitor {
        public AnnotationDependencyVisitor() {
            super(327680);
        }

        public void visit(String name, Object value) {
            if (value instanceof Type) {
                AbstractDependencyVisitor.this.addType((Type)value);
            }
        }

        public void visitEnum(String name, String desc, String value) {
            AbstractDependencyVisitor.this.addDesc(desc);
        }

        public AnnotationVisitor visitAnnotation(String name, String desc) {
            AbstractDependencyVisitor.this.addDesc(desc);
            return this;
        }

        public AnnotationVisitor visitArray(String name) {
            return this;
        }
    }
}

