/*
 * Decompiled with CFR 0.152.
 */
package com.sun.jini.tool.envcheck;

import com.sun.jini.tool.envcheck.EnvCheck;
import com.sun.jini.tool.envcheck.Util;
import java.util.HashSet;
import java.util.ResourceBundle;
import java.util.StringTokenizer;

public abstract class Reporter {
    public static final int INFO = 0;
    public static final int WARNING = 1;
    public static final int ERROR = 2;
    private static String sourceString;
    private static String[] msgHeaders;
    private static boolean explain;
    private static int reportingLevel;
    private static int warningCount;
    private static int errorCount;
    private static boolean traces;
    private static HashSet explanationsGiven;

    private Reporter() {
    }

    public static void setLevel(int level) {
        reportingLevel = level;
    }

    public static void setExplanation(boolean explain) {
        Reporter.explain = explain;
    }

    public static void setPrintTraces(boolean traces) {
        Reporter.traces = traces;
    }

    public static void print(Message message) {
        Reporter.print(message, null);
    }

    public static void print(Message message, String source) {
        int messageLevel = message.getLevel();
        if (reportingLevel > messageLevel) {
            return;
        }
        if (messageLevel == 1) {
            ++warningCount;
        } else if (messageLevel == 2) {
            ++errorCount;
        }
        System.out.println();
        System.out.println(msgHeaders[messageLevel] + " " + message.getMessage());
        if (source != null) {
            System.out.println(sourceString + " " + source);
        }
        if (explain) {
            Reporter.printExplanation(message);
        }
        if (traces) {
            message.printStackTrace();
        }
    }

    private static void printExplanation(Message message) {
        String exp = message.getExplanation();
        if (exp == null) {
            return;
        }
        if (explanationsGiven.contains(exp)) {
            return;
        }
        explanationsGiven.add(exp);
        if (message.formatExplanation()) {
            String indent = "    ";
            int lineMax = 70;
            StringBuffer buf = new StringBuffer();
            StringTokenizer tok = new StringTokenizer(exp);
            int lineStart = 0;
            while (tok.hasMoreTokens()) {
                String nextWord = tok.nextToken();
                int lineLength = buf.length() + nextWord.length() + 1 - lineStart;
                if (lineLength > lineMax) {
                    buf.append("\n");
                    lineStart = buf.length();
                }
                if (lineStart == buf.length()) {
                    buf.append(indent);
                } else {
                    buf.append(" ");
                }
                buf.append(nextWord);
            }
            if (buf.length() > lineStart) {
                buf.append("\n");
            }
            if ((exp = buf.toString()).length() > 0) {
                System.out.println();
            }
        }
        System.out.println(exp);
    }

    public static int getWarningCount() {
        return warningCount;
    }

    public static int getErrorCount() {
        return errorCount;
    }

    static {
        msgHeaders = new String[3];
        explain = false;
        reportingLevel = 1;
        warningCount = 0;
        errorCount = 0;
        traces = false;
        explanationsGiven = new HashSet();
        ResourceBundle bundle = Util.getResourceBundle(EnvCheck.class);
        Reporter.msgHeaders[0] = Util.getString("reporter.info", bundle);
        Reporter.msgHeaders[1] = Util.getString("reporter.warning", bundle);
        Reporter.msgHeaders[2] = Util.getString("reporter.error", bundle);
        sourceString = Util.getString("reporter.source", bundle);
    }

    public static class Message {
        private Throwable thrownException = null;
        private String message = null;
        private String explanation = null;
        private int level = -1;
        private boolean formatExplanation = true;

        public Message(int level, String message, String explanation) {
            this.level = level;
            this.message = message;
            this.explanation = explanation;
        }

        public Message(int level, String message, Throwable thrownException, String explanation) {
            this.level = level;
            this.message = message;
            this.thrownException = thrownException;
            this.explanation = explanation;
        }

        protected int getLevel() {
            if (this.level == -1) {
                throw new IllegalStateException("Bad Level");
            }
            return this.level;
        }

        protected String getMessage() {
            String buf = "";
            if (this.message != null) {
                buf = this.message;
                if (this.thrownException != null) {
                    buf = buf + ": ";
                }
            }
            if (this.thrownException != null) {
                buf = buf + this.thrownException.getMessage();
            }
            if (buf.length() == 0) {
                throw new IllegalStateException("No Message");
            }
            return buf;
        }

        protected String getExplanation() {
            return this.explanation;
        }

        protected void printStackTrace() {
            if (this.thrownException != null) {
                this.thrownException.printStackTrace();
            }
        }

        protected void setFormatExplanation(boolean b) {
            this.formatExplanation = b;
        }

        protected boolean formatExplanation() {
            return this.formatExplanation;
        }
    }
}

