/*
 * Decompiled with CFR 0.152.
 */
package com.sun.jini.tool.envcheck.plugins;

import com.sun.jini.tool.envcheck.AbstractPlugin;
import com.sun.jini.tool.envcheck.EnvCheck;
import com.sun.jini.tool.envcheck.Reporter;
import com.sun.jini.tool.envcheck.SubVMTask;
import com.sun.jini.tool.envcheck.Util;
import com.sun.jini.tool.envcheck.plugins.FileAccessCheckTask;
import java.io.File;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URL;
import java.security.Policy;
import java.security.Security;
import java.util.ArrayList;
import java.util.Properties;
import java.util.ResourceBundle;
import javax.security.auth.login.Configuration;
import net.jini.security.policy.DynamicPolicyProvider;

public class CheckJsseProps
extends AbstractPlugin {
    EnvCheck envCheck;
    private static boolean doChecks = false;
    String fileAccessTask = FileAccessCheckTask.class.getName();

    public boolean isPluginOption(String opt) {
        if (opt.equals("-security")) {
            doChecks = true;
            return true;
        }
        return false;
    }

    public void run(EnvCheck envCheck) {
        if (!doChecks) {
            return;
        }
        this.envCheck = envCheck;
        this.checkProvider();
        this.checkTrustStore();
        this.checkDiscoveryStore();
        this.checkKeyStore();
        this.checkLoginConfigs();
    }

    private String getSource() {
        return this.getString("cmdlineVM");
    }

    private String[] args(String s1, String s2) {
        return new String[]{s1, s2};
    }

    private void checkTrustStore() {
        String source = this.getSource();
        String name = "javax.net.ssl.trustStore";
        String phrase = this.getString("truststore");
        if (this.checkExistance(name, phrase, source)) {
            Object lobj = this.envCheck.launch(this.fileAccessTask, this.args(name, phrase));
            Reporter.Message message = lobj == null ? new Reporter.Message(0, this.getString("truststoreOK"), this.getString("configExp", phrase, name)) : (lobj instanceof String ? new Reporter.Message(2, (String)lobj, this.getString("configExp", phrase, name)) : new Reporter.Message(2, this.getString("accessexception", phrase, name), (Throwable)lobj, this.getString("configExp", phrase, name)));
            Reporter.print(message, source);
        }
    }

    private void checkDiscoveryStore() {
        String source = this.getSource();
        String name = "com.sun.jini.discovery.x500.trustStore";
        String phrase = this.getString("discoverystore");
        if (this.checkExistance(name, phrase, source)) {
            Object lobj = this.envCheck.launch(null, this.fileAccessTask, this.args(name, phrase));
            Reporter.Message message = lobj == null ? new Reporter.Message(0, this.getString("discoverystoreOK"), this.getString("dsExp")) : (lobj instanceof String ? new Reporter.Message(2, (String)lobj, this.getString("dsExp")) : new Reporter.Message(2, this.getString("accessexception", phrase, name), (Throwable)lobj, this.getString("dsExp")));
            Reporter.print(message, source);
        }
    }

    private void checkKeyStore() {
        String source = this.getSource();
        String name = "javax.net.ssl.keyStore";
        String phrase = this.getString("keystore");
        if (this.checkExistance(name, phrase, source)) {
            Object lobj = this.envCheck.launch(null, this.fileAccessTask, this.args(name, phrase));
            Reporter.Message message = lobj == null ? new Reporter.Message(0, this.getString("keystoreOK"), this.getString("configExp", phrase, name)) : (lobj instanceof String ? new Reporter.Message(2, (String)lobj, this.getString("configExp", phrase, name)) : new Reporter.Message(2, this.getString("accessexception", phrase, name), (Throwable)lobj, this.getString("configExp", phrase, name)));
            Reporter.print(message, source);
        }
    }

    private void checkLoginConfigs() {
        Reporter.Message message;
        String source = this.getSource();
        Object lobj = this.envCheck.launch(null, this.taskName("GetGroupLoginConfigs"));
        if (lobj instanceof Throwable) {
            this.handleUnexpectedSubtaskReturn(lobj, source);
            return;
        }
        ArrayList configs = (ArrayList)lobj;
        if (configs.size() == 0) {
            message = new Reporter.Message(1, this.getString("noconfigfiles"), this.getString("loginConfigExp"));
            Reporter.print(message, source);
        }
        for (int i = 0; i < configs.size(); i += 2) {
            String errorMsg;
            String desc = (String)configs.get(i + 1);
            if (configs.get(i) instanceof URL) {
                URL url = (URL)configs.get(i);
                errorMsg = Util.checkURL(url, desc);
            } else {
                errorMsg = (String)configs.get(i);
            }
            message = errorMsg == null ? new Reporter.Message(0, this.getString("loginconfigOK"), this.getString("loginConfigExp")) : new Reporter.Message(2, errorMsg, this.getString("loginConfigExp"));
            Reporter.print(message, source + " " + desc);
        }
        lobj = this.envCheck.launch(null, this.taskName("CheckLoginConfigInit"));
        if (lobj == null) {
            message = new Reporter.Message(0, this.getString("loginInitOK"), this.getString("loginConfigExp"));
            Reporter.print(message, source);
        } else {
            Throwable cause = ((Throwable)lobj).getCause();
            if (cause instanceof IOException) {
                message = new Reporter.Message(0, this.getString("loginInitBad"), cause, this.getString("loginConfigExp"));
                Reporter.print(message, source);
            } else {
                this.handleUnexpectedSubtaskReturn(lobj, source);
            }
        }
    }

    private static ArrayList getLoginConfigs() {
        String config_url;
        ResourceBundle bundle = Util.getResourceBundle(CheckJsseProps.class);
        ArrayList<Object> list = new ArrayList<Object>();
        boolean override = false;
        String propDefined = System.getProperty("java.security.auth.login.config");
        if (propDefined != null) {
            String source = Util.getString("fromProp", bundle);
            if (propDefined.indexOf(61) == 0) {
                override = true;
                propDefined = propDefined.substring(1);
                source = source + " " + Util.getString("withOverride", bundle);
            }
            try {
                list.add(new URL("file:" + propDefined));
            }
            catch (MalformedURLException e) {
                list.add(Util.getString("badname", bundle, propDefined));
            }
            list.add(source);
            if (override) {
                return list;
            }
        }
        int n = 1;
        while ((config_url = Security.getProperty("login.config.url." + n)) != null) {
            try {
                list.add(new URL(config_url));
            }
            catch (MalformedURLException e) {
                list.add(Util.getString("malformedurl", bundle, config_url));
            }
            list.add(Util.getString("secprop", bundle, "login.config.url." + n));
            ++n;
        }
        if (list.size() == 0) {
            String userFile = System.getProperty("user.home");
            if (new File(userFile = userFile + File.separator + ".java.login.config").exists()) {
                try {
                    list.add(new URL("file:" + userFile));
                    list.add(Util.getString("userfile", bundle));
                }
                catch (MalformedURLException e) {
                    e.printStackTrace();
                }
            }
        }
        return list;
    }

    private boolean checkExistance(String propName, String desc, String source) {
        Properties p = System.getProperties();
        if (p == null || p.getProperty(propName) == null) {
            Reporter.Message message = new Reporter.Message(1, this.getString("noprop", propName, desc), this.getString("configExp", desc, propName));
            Reporter.print(message, source);
            return false;
        }
        return true;
    }

    private void checkProvider() {
        String source = this.getSource();
        Object lobj = this.envCheck.launch(null, this.taskName("CheckProviderTask"));
        if (lobj instanceof Boolean) {
            Reporter.Message message = (Boolean)lobj != false ? new Reporter.Message(0, this.getString("providerOK"), this.getString("providerExp")) : new Reporter.Message(1, this.getString("providerBad"), this.getString("providerExp"));
            Reporter.print(message, source);
        } else {
            this.handleUnexpectedSubtaskReturn(lobj, source);
        }
    }

    public static class GetGroupLoginConfigs
    implements SubVMTask {
        public Object run(String[] args) {
            return CheckJsseProps.getLoginConfigs();
        }
    }

    public static class CheckProviderTask
    implements SubVMTask {
        public Object run(String[] args) {
            try {
                if (Policy.getPolicy() instanceof DynamicPolicyProvider) {
                    return new Boolean(true);
                }
                return new Boolean(false);
            }
            catch (SecurityException e) {
                return e;
            }
        }
    }

    public static class CheckLoginConfigInit
    implements SubVMTask {
        public Object run(String[] args) {
            try {
                Configuration.getConfiguration();
                return null;
            }
            catch (SecurityException e) {
                return e;
            }
        }
    }
}

