/*
 * Decompiled with CFR 0.152.
 */
package com.sun.jini.tool.envcheck.plugins;

import com.sun.jini.start.NonActivatableServiceDescriptor;
import com.sun.jini.start.ServiceDescriptor;
import com.sun.jini.tool.envcheck.AbstractPlugin;
import com.sun.jini.tool.envcheck.EnvCheck;
import com.sun.jini.tool.envcheck.Reporter;
import com.sun.jini.tool.envcheck.SubVMTask;
import com.sun.jini.tool.envcheck.Util;
import java.io.ByteArrayOutputStream;
import java.io.PrintStream;
import java.net.URL;
import java.security.AllPermission;
import java.security.CodeSource;
import java.security.PermissionCollection;
import java.security.Policy;
import java.security.cert.Certificate;

public class CheckPolicy
extends AbstractPlugin {
    private EnvCheck envCheck;

    public void run(EnvCheck envCheck) {
        this.envCheck = envCheck;
        this.checkProperty();
        ServiceDescriptor[] d = envCheck.getDescriptors();
        for (int i = 0; i < d.length; ++i) {
            this.checkDescriptor(d[i]);
        }
    }

    private void checkProperty() {
        String policyName = this.envCheck.getProperty("java.security.policy");
        if (this.policyAccessible(policyName, this.getString("policyprop"))) {
            Object o = this.envCheck.launch(this.taskName("AllPermissionsTask"));
            String source = this.getString("cmdpolicy", policyName);
            if (o instanceof String) {
                Reporter.Message message = new Reporter.Message(2, this.getString("parseerror", o), null);
                Reporter.print(message, source);
            } else if (o instanceof Boolean) {
                if (((Boolean)o).booleanValue()) {
                    Reporter.Message message = new Reporter.Message(1, this.getString("grantsall"), this.getString("allExp"));
                    Reporter.print(message, source);
                }
            } else {
                this.handleUnexpectedSubtaskReturn(o, source);
            }
        }
    }

    private static String loadPolicy() {
        PrintStream oldErr = System.err;
        ByteArrayOutputStream s = new ByteArrayOutputStream();
        System.setErr(new PrintStream(s));
        Policy policy = Policy.getPolicy();
        System.setErr(oldErr);
        return s.toString();
    }

    private boolean policyAccessible(String policy, String source) {
        boolean ret;
        Reporter.Message message;
        if (policy == null) {
            message = new Reporter.Message(1, this.getString("nopolicy"), this.getString("policyExp"));
            ret = false;
        } else {
            String errorMsg = Util.checkFileName(policy, this.getString("policyfile"));
            if (errorMsg != null) {
                message = new Reporter.Message(2, errorMsg, this.getString("policyExp"));
                ret = false;
            } else {
                message = new Reporter.Message(0, this.getString("policyOK"), this.getString("policyExp"));
                ret = true;
            }
        }
        Reporter.print(message, source);
        return ret;
    }

    private void checkDescriptor(ServiceDescriptor d) {
        NonActivatableServiceDescriptor nad = null;
        String source = null;
        nad = (NonActivatableServiceDescriptor)d;
        String policy = nad.getPolicy();
        if (!this.policyAccessible(policy, source = this.getString("for", policy, nad.getImplClassName()))) {
            return;
        }
        Object o = this.envCheck.launch(nad, this.taskName("AllPermissionsTask"));
        if (o instanceof String) {
            Reporter.Message message = new Reporter.Message(2, this.getString("parseerror", o), null);
            Reporter.print(message, source);
        } else if (o instanceof Boolean) {
            if (((Boolean)o).booleanValue()) {
                Reporter.Message message = new Reporter.Message(1, this.getString("grantsall"), this.getString("allExp"));
                Reporter.print(message, source);
            }
        } else {
            this.handleUnexpectedSubtaskReturn(o, source);
        }
    }

    public static class AllPermissionsTask
    implements SubVMTask {
        public Object run(String[] args) {
            String errMsg = CheckPolicy.loadPolicy();
            if (errMsg.length() > 0) {
                return errMsg;
            }
            try {
                Policy policy = Policy.getPolicy();
                PermissionCollection permCol = policy.getPermissions(new CodeSource(new URL("file:/foo"), (Certificate[])null));
                if (permCol.implies(new AllPermission("", ""))) {
                    return new Boolean(true);
                }
            }
            catch (SecurityException e) {
            }
            catch (Throwable t) {
                return t;
            }
            return new Boolean(false);
        }
    }
}

