/*
 * Decompiled with CFR 0.152.
 */
package org.apache.samza.checkpoint;

import java.util.Objects;
import org.apache.commons.lang3.StringUtils;
import org.apache.samza.annotation.InterfaceStability;

@InterfaceStability.Unstable
public class CheckpointId {
    public static final String SEPARATOR = "-";
    private final long millis;
    private final long nanos;

    public CheckpointId(long millis, long nanos) {
        this.millis = millis;
        this.nanos = nanos;
    }

    public static CheckpointId create() {
        return new CheckpointId(System.currentTimeMillis(), System.nanoTime() % 1000000L);
    }

    public static CheckpointId fromString(String checkpointId) {
        if (StringUtils.isBlank((CharSequence)checkpointId)) {
            throw new IllegalArgumentException("Invalid checkpoint id: " + checkpointId);
        }
        String[] parts = checkpointId.split(SEPARATOR);
        return new CheckpointId(Long.parseLong(parts[0]), Long.parseLong(parts[1]));
    }

    public long getMillis() {
        return this.millis;
    }

    public long getNanos() {
        return this.nanos;
    }

    public String toString() {
        return String.format("%s%s%s", this.millis, SEPARATOR, this.nanos);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        CheckpointId that = (CheckpointId)o;
        return this.millis == that.millis && this.nanos == that.nanos;
    }

    public int hashCode() {
        return Objects.hash(this.millis, this.nanos);
    }
}

