/*
 * Decompiled with CFR 0.152.
 */
package org.apache.samza.checkpoint;

import java.util.Objects;
import org.apache.commons.lang3.StringUtils;
import org.apache.samza.annotation.InterfaceStability;
import org.apache.samza.checkpoint.CheckpointId;

@InterfaceStability.Unstable
public class CheckpointedChangelogOffset {
    public static final String SEPARATOR = ":";
    private final CheckpointId checkpointId;
    private final String offset;

    public CheckpointedChangelogOffset(CheckpointId checkpointId, String offset) {
        this.checkpointId = checkpointId;
        this.offset = offset;
    }

    public static CheckpointedChangelogOffset fromString(String message) {
        if (StringUtils.isBlank((CharSequence)message)) {
            throw new IllegalArgumentException("Invalid checkpointed changelog message: " + message);
        }
        String[] checkpointIdAndOffset = message.split(SEPARATOR);
        if (checkpointIdAndOffset.length != 2) {
            throw new IllegalArgumentException("Invalid checkpointed changelog offset: " + message);
        }
        CheckpointId checkpointId = CheckpointId.fromString(checkpointIdAndOffset[0]);
        String offset = null;
        if (!"null".equals(checkpointIdAndOffset[1])) {
            offset = checkpointIdAndOffset[1];
        }
        return new CheckpointedChangelogOffset(checkpointId, offset);
    }

    public CheckpointId getCheckpointId() {
        return this.checkpointId;
    }

    public String getOffset() {
        return this.offset;
    }

    public String toString() {
        return String.format("%s%s%s", this.checkpointId, SEPARATOR, this.offset);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        CheckpointedChangelogOffset that = (CheckpointedChangelogOffset)o;
        return Objects.equals(this.checkpointId, that.checkpointId) && Objects.equals(this.offset, that.offset);
    }

    public int hashCode() {
        return Objects.hash(this.checkpointId, this.offset);
    }
}

