/*
 * Decompiled with CFR 0.152.
 */
package org.apache.samza.container.placement;

import com.google.common.base.Preconditions;
import java.time.Duration;
import java.util.Objects;
import java.util.UUID;
import org.apache.samza.container.placement.ContainerPlacementMessage;
import org.apache.samza.container.placement.ContainerPlacementRequestMessage;

public class ContainerPlacementResponseMessage
extends ContainerPlacementMessage {
    private String responseMessage;

    public ContainerPlacementResponseMessage(UUID uuid, String deploymentId, String processorId, String destinationHost, Duration requestExpiry, ContainerPlacementMessage.StatusCode statusCode, String responseMessage, long timestamp) {
        super(uuid, deploymentId, processorId, destinationHost, requestExpiry, statusCode, timestamp);
        Preconditions.checkNotNull((Object)responseMessage);
        this.responseMessage = responseMessage;
    }

    public ContainerPlacementResponseMessage(UUID uuid, String deploymentId, String processorId, String destinationHost, ContainerPlacementMessage.StatusCode statusCode, String responseMessage, long timestamp) {
        this(uuid, deploymentId, processorId, destinationHost, null, statusCode, responseMessage, timestamp);
    }

    public static ContainerPlacementResponseMessage fromContainerPlacementRequestMessage(ContainerPlacementRequestMessage requestMessage, ContainerPlacementMessage.StatusCode statusCode, String responseMessage, long timestamp) {
        return new ContainerPlacementResponseMessage(requestMessage.getUuid(), requestMessage.getDeploymentId(), requestMessage.getProcessorId(), requestMessage.getDestinationHost(), requestMessage.getRequestExpiry(), statusCode, responseMessage, timestamp);
    }

    public String getResponseMessage() {
        return this.responseMessage;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder("ContainerPlacementResponseMessage{");
        sb.append(" UUID: ").append(this.uuid);
        sb.append(", Processor ID: ").append(this.processorId);
        sb.append(", deploymentId='").append(this.deploymentId).append('\'');
        sb.append(", destinationHost='").append(this.destinationHost).append('\'');
        sb.append(", requestExpiry=").append(this.requestExpiry);
        sb.append(", statusCode=").append((Object)this.statusCode);
        sb.append(", timestamp=").append(this.timestamp);
        sb.append(", responseMessage='").append(this.responseMessage).append('\'');
        sb.append('}');
        return sb.toString();
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        ContainerPlacementResponseMessage that = (ContainerPlacementResponseMessage)o;
        return this.getResponseMessage().equals(that.getResponseMessage());
    }

    @Override
    public int hashCode() {
        return Objects.hash(super.hashCode(), this.getResponseMessage());
    }
}

