/*
 * Decompiled with CFR 0.152.
 */
package org.apache.samza.job;

public class ApplicationStatus {
    public static final ApplicationStatus New = new ApplicationStatus(StatusCode.New, null);
    public static final ApplicationStatus Running = new ApplicationStatus(StatusCode.Running, null);
    public static final ApplicationStatus SuccessfulFinish = new ApplicationStatus(StatusCode.SuccessfulFinish, null);
    public static final ApplicationStatus UnsuccessfulFinish = new ApplicationStatus(StatusCode.UnsuccessfulFinish, null);
    private final StatusCode statusCode;
    private final Throwable throwable;

    private ApplicationStatus(StatusCode code, Throwable t) {
        this.statusCode = code;
        this.throwable = t;
    }

    public StatusCode getStatusCode() {
        return this.statusCode;
    }

    public Throwable getThrowable() {
        return this.throwable;
    }

    public String toString() {
        return this.statusCode.name();
    }

    public static ApplicationStatus unsuccessfulFinish(Throwable t) {
        return new ApplicationStatus(StatusCode.UnsuccessfulFinish, t);
    }

    public boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        if (obj == this) {
            return true;
        }
        if (obj.getClass() != this.getClass()) {
            return false;
        }
        ApplicationStatus rhs = (ApplicationStatus)obj;
        return this.statusCode.equals((Object)rhs.statusCode);
    }

    public int hashCode() {
        return this.statusCode.hashCode();
    }

    public static enum StatusCode {
        New,
        Running,
        SuccessfulFinish,
        UnsuccessfulFinish;

    }
}

