/*
 * Decompiled with CFR 0.152.
 */
package org.apache.samza.metrics;

import java.util.concurrent.ConcurrentSkipListMap;
import java.util.concurrent.atomic.AtomicLong;
import org.apache.samza.metrics.Reservoir;
import org.apache.samza.metrics.Snapshot;
import org.apache.samza.util.Clock;

public class SlidingTimeWindowReservoir
implements Reservoir {
    private static final int DEFAULT_TIME_COLLISION_BUFFER = 1;
    private static final int REMOVE_IN_UPDATE_THRESHOLD = 256;
    private static final int DEFAULT_WINDOW_SIZE_MS = 300000;
    private final int collisionBuffer;
    private final long windowMs;
    private final ConcurrentSkipListMap<Long, Long> storage;
    private final AtomicLong count;
    private final AtomicLong lastUpdatingTime;
    private final Clock clock;

    public SlidingTimeWindowReservoir() {
        this(300000L, new Clock(){

            @Override
            public long currentTimeMillis() {
                return System.currentTimeMillis();
            }
        });
    }

    public SlidingTimeWindowReservoir(long windowMs) {
        this(windowMs, new Clock(){

            @Override
            public long currentTimeMillis() {
                return System.currentTimeMillis();
            }
        });
    }

    public SlidingTimeWindowReservoir(long windowMs, Clock clock) {
        this(windowMs, 1, clock);
    }

    public SlidingTimeWindowReservoir(long windowMs, int collisionBuffer, Clock clock) {
        this.windowMs = windowMs * (long)collisionBuffer;
        this.storage = new ConcurrentSkipListMap();
        this.count = new AtomicLong();
        this.lastUpdatingTime = new AtomicLong();
        this.clock = clock;
        this.collisionBuffer = collisionBuffer;
    }

    @Override
    public int size() {
        this.removeExpireValues();
        return this.storage.size();
    }

    @Override
    public void update(long value) {
        if (this.count.incrementAndGet() % 256L == 0L) {
            this.removeExpireValues();
        }
        this.storage.put(this.getUpdatingTime(), value);
    }

    private void removeExpireValues() {
        this.storage.headMap((Object)(this.getUpdatingTime() - this.windowMs)).clear();
    }

    private long getUpdatingTime() {
        long updatingTime;
        long oldTime;
        do {
            oldTime = this.lastUpdatingTime.get();
            long newTime = this.clock.currentTimeMillis() * (long)this.collisionBuffer;
            long l = updatingTime = newTime > oldTime ? newTime : oldTime + 1L;
            if (updatingTime != newTime + (long)this.collisionBuffer) continue;
            --updatingTime;
        } while (!this.lastUpdatingTime.compareAndSet(oldTime, updatingTime));
        return updatingTime;
    }

    @Override
    public Snapshot getSnapshot() {
        this.removeExpireValues();
        return new Snapshot(this.storage.values());
    }
}

