/*
 * Decompiled with CFR 0.152.
 */
package org.apache.samza.operators;

import java.time.Duration;
import java.util.ArrayList;
import java.util.Collection;
import org.apache.samza.annotation.InterfaceStability;
import org.apache.samza.operators.KV;
import org.apache.samza.operators.OutputStream;
import org.apache.samza.operators.functions.AsyncFlatMapFunction;
import org.apache.samza.operators.functions.FilterFunction;
import org.apache.samza.operators.functions.FlatMapFunction;
import org.apache.samza.operators.functions.JoinFunction;
import org.apache.samza.operators.functions.MapFunction;
import org.apache.samza.operators.functions.SinkFunction;
import org.apache.samza.operators.functions.StreamTableJoinFunction;
import org.apache.samza.operators.windows.Window;
import org.apache.samza.operators.windows.WindowPane;
import org.apache.samza.serializers.KVSerde;
import org.apache.samza.serializers.Serde;
import org.apache.samza.table.Table;

@InterfaceStability.Evolving
public interface MessageStream<M> {
    public <OM> MessageStream<OM> map(MapFunction<? super M, ? extends OM> var1);

    public <OM> MessageStream<OM> flatMap(FlatMapFunction<? super M, ? extends OM> var1);

    public <OM> MessageStream<OM> flatMapAsync(AsyncFlatMapFunction<? super M, ? extends OM> var1);

    public MessageStream<M> filter(FilterFunction<? super M> var1);

    public void sink(SinkFunction<? super M> var1);

    public MessageStream<M> sendTo(OutputStream<M> var1);

    public <K, WV> MessageStream<WindowPane<K, WV>> window(Window<M, K, WV> var1, String var2);

    public <K, OM, JM> MessageStream<JM> join(MessageStream<OM> var1, JoinFunction<? extends K, ? super M, ? super OM, ? extends JM> var2, Serde<K> var3, Serde<M> var4, Serde<OM> var5, Duration var6, String var7);

    public <K, R extends KV, JM> MessageStream<JM> join(Table<R> var1, StreamTableJoinFunction<? extends K, ? super M, ? super R, ? extends JM> var2, Object ... var3);

    public MessageStream<M> merge(Collection<? extends MessageStream<? extends M>> var1);

    public static <T> MessageStream<T> mergeAll(Collection<? extends MessageStream<? extends T>> streams) {
        if (streams.isEmpty()) {
            throw new IllegalArgumentException("No streams to merge.");
        }
        ArrayList<MessageStream<T>> messageStreams = new ArrayList<MessageStream<T>>(streams);
        MessageStream<T> firstStream = messageStreams.remove(0);
        return firstStream.merge(messageStreams);
    }

    public <K, V> MessageStream<KV<K, V>> partitionBy(MapFunction<? super M, ? extends K> var1, MapFunction<? super M, ? extends V> var2, KVSerde<K, V> var3, String var4);

    public <K, V> MessageStream<KV<K, V>> sendTo(Table<KV<K, V>> var1, Object ... var2);

    public MessageStream<M> broadcast(Serde<M> var1, String var2);
}

