/*
 * Decompiled with CFR 0.152.
 */
package org.apache.samza.operators.windows.internal;

import org.apache.samza.annotation.InterfaceStability;
import org.apache.samza.operators.functions.FoldLeftFunction;
import org.apache.samza.operators.functions.MapFunction;
import org.apache.samza.operators.functions.SupplierFunction;
import org.apache.samza.operators.triggers.Trigger;
import org.apache.samza.operators.windows.AccumulationMode;
import org.apache.samza.operators.windows.Window;
import org.apache.samza.operators.windows.internal.WindowType;
import org.apache.samza.serializers.Serde;

@InterfaceStability.Unstable
public final class WindowInternal<M, WK, WV>
implements Window<M, WK, WV> {
    private final Trigger<M> defaultTrigger;
    private final SupplierFunction<WV> initializer;
    private final FoldLeftFunction<M, WV> foldLeftFunction;
    private final MapFunction<M, WK> keyExtractor;
    private final MapFunction<M, Long> eventTimeExtractor;
    private final WindowType windowType;
    private Trigger<M> earlyTrigger;
    private Trigger<M> lateTrigger;
    private AccumulationMode mode;
    private final transient Serde<WK> keySerde;
    private final transient Serde<WV> windowValSerde;
    private final transient Serde<M> msgSerde;

    public WindowInternal(Trigger<M> defaultTrigger, SupplierFunction<WV> initializer, FoldLeftFunction<M, WV> foldLeftFunction, MapFunction<M, WK> keyExtractor, MapFunction<M, Long> eventTimeExtractor, WindowType windowType, Serde<WK> keySerde, Serde<WV> windowValueSerde, Serde<M> msgSerde) {
        this.defaultTrigger = defaultTrigger;
        this.initializer = initializer;
        this.foldLeftFunction = foldLeftFunction;
        this.eventTimeExtractor = eventTimeExtractor;
        this.keyExtractor = keyExtractor;
        this.windowType = windowType;
        this.keySerde = keySerde;
        this.windowValSerde = windowValueSerde;
        this.msgSerde = msgSerde;
        if (defaultTrigger == null) {
            throw new IllegalArgumentException("A window must not have a null default trigger");
        }
        if (msgSerde == null && windowValueSerde == null) {
            throw new IllegalArgumentException("A window must not have a null msg serde and a null windowValue serde");
        }
        if (foldLeftFunction != null && this.windowValSerde == null) {
            throw new IllegalArgumentException("A window with a FoldLeftFunction must have a windowValue serde");
        }
        if (foldLeftFunction != null && initializer == null) {
            throw new IllegalArgumentException("A window with a FoldLeftFunction must have an initializer");
        }
        if (foldLeftFunction == null && initializer != null) {
            throw new IllegalArgumentException("A window without a provided FoldLeftFunction must not have an initializer");
        }
    }

    public Trigger<M> getDefaultTrigger() {
        return this.defaultTrigger;
    }

    public Trigger<M> getEarlyTrigger() {
        return this.earlyTrigger;
    }

    public Trigger<M> getLateTrigger() {
        return this.lateTrigger;
    }

    public SupplierFunction<WV> getInitializer() {
        return this.initializer;
    }

    public FoldLeftFunction<M, WV> getFoldLeftFunction() {
        return this.foldLeftFunction;
    }

    public MapFunction<M, WK> getKeyExtractor() {
        return this.keyExtractor;
    }

    public MapFunction<M, Long> getEventTimeExtractor() {
        return this.eventTimeExtractor;
    }

    public WindowType getWindowType() {
        return this.windowType;
    }

    public AccumulationMode getAccumulationMode() {
        return this.mode;
    }

    public Serde<WK> getKeySerde() {
        return this.keySerde;
    }

    public Serde<WV> getWindowValSerde() {
        return this.windowValSerde;
    }

    public Serde<M> getMsgSerde() {
        return this.msgSerde;
    }

    public AccumulationMode getMode() {
        return this.mode;
    }

    @Override
    public Window<M, WK, WV> setEarlyTrigger(Trigger<M> trigger) {
        this.earlyTrigger = trigger;
        return this;
    }

    @Override
    public Window<M, WK, WV> setLateTrigger(Trigger<M> trigger) {
        this.lateTrigger = trigger;
        return this;
    }

    @Override
    public Window<M, WK, WV> setAccumulationMode(AccumulationMode mode) {
        this.mode = mode;
        return this;
    }
}

