/*
 * Decompiled with CFR 0.152.
 */
package org.apache.samza.runtime;

import java.lang.reflect.Constructor;
import org.apache.samza.application.SamzaApplication;
import org.apache.samza.config.Config;
import org.apache.samza.config.ConfigException;
import org.apache.samza.runtime.ApplicationRunner;

public class ApplicationRunners {
    private static final String APP_RUNNER_CFG = "app.runner.class";
    private static final String DEFAULT_APP_RUNNER = "org.apache.samza.runtime.RemoteApplicationRunner";

    private ApplicationRunners() {
    }

    public static final ApplicationRunner getApplicationRunner(SamzaApplication userApp, Config config) {
        String appRunnerClassName = ApplicationRunners.getAppRunnerClass(config);
        try {
            Class<?> runnerClass = Class.forName(appRunnerClassName);
            if (!ApplicationRunner.class.isAssignableFrom(runnerClass)) {
                throw new ConfigException(String.format("Class %s does not extend ApplicationRunner properly", appRunnerClassName));
            }
            Constructor<?> constructor = runnerClass.getConstructor(SamzaApplication.class, Config.class);
            return (ApplicationRunner)constructor.newInstance(userApp, config);
        }
        catch (ConfigException ce) {
            throw ce;
        }
        catch (Exception e) {
            throw new ConfigException(String.format("Could not load ApplicationRunner class %s", appRunnerClassName), e);
        }
    }

    private static String getAppRunnerClass(Config config) {
        return config.getOrDefault(APP_RUNNER_CFG, DEFAULT_APP_RUNNER);
    }
}

