/*
 * Decompiled with CFR 0.152.
 */
package org.apache.samza.sql;

import com.google.common.base.Joiner;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import org.apache.samza.annotation.InterfaceStability;
import org.codehaus.jackson.annotate.JsonProperty;

@InterfaceStability.Unstable
public class SamzaSqlRelRecord
implements Serializable {
    @JsonProperty(value="fieldNames")
    private final ArrayList<String> fieldNames;
    @JsonProperty(value="fieldValues")
    private final ArrayList<Object> fieldValues;
    private final int hashCode;

    public SamzaSqlRelRecord(@JsonProperty(value="fieldNames") List<String> fieldNames, @JsonProperty(value="fieldValues") List<Object> fieldValues) {
        if (fieldNames.size() != fieldValues.size()) {
            throw new IllegalArgumentException("Field Names and values are not of same length.");
        }
        this.fieldNames = new ArrayList();
        this.fieldValues = new ArrayList();
        this.fieldNames.addAll(fieldNames);
        this.fieldValues.addAll(fieldValues);
        this.hashCode = Objects.hash(fieldNames, fieldValues);
    }

    @JsonProperty(value="fieldNames")
    public List<String> getFieldNames() {
        return this.fieldNames;
    }

    @JsonProperty(value="fieldValues")
    public List<Object> getFieldValues() {
        return this.fieldValues;
    }

    public Optional<Object> getField(String name) {
        int index = this.fieldNames.indexOf(name);
        if (index != -1) {
            return Optional.ofNullable(this.fieldValues.get(index));
        }
        return Optional.empty();
    }

    public int hashCode() {
        return this.hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        SamzaSqlRelRecord other = (SamzaSqlRelRecord)obj;
        return Objects.equals(this.fieldNames, other.fieldNames) && Objects.equals(this.fieldValues, other.fieldValues);
    }

    public String toString() {
        String nameStr = Joiner.on((String)",").join(this.fieldNames);
        String valueStr = Joiner.on((String)",").useForNull("null").join(this.fieldValues);
        return "[Names:{" + nameStr + "} Values:{" + valueStr + "}]";
    }

    public boolean containsField(String name) {
        return this.fieldNames.indexOf(name) != -1;
    }
}

