/*
 * Decompiled with CFR 0.152.
 */
package org.apache.samza.sql.schema;

import org.apache.samza.sql.schema.SamzaSqlFieldType;
import org.apache.samza.sql.schema.SqlSchema;

public class SqlFieldSchema {
    private final SamzaSqlFieldType fieldType;
    private final SqlFieldSchema elementType;
    private final SqlFieldSchema valueType;
    private final SqlSchema rowSchema;
    private final Boolean isNullable;
    private final Boolean isOptional;

    private SqlFieldSchema(SamzaSqlFieldType fieldType, SqlFieldSchema elementType, SqlFieldSchema valueType, SqlSchema rowSchema, boolean isNullable, boolean isOptional) {
        this.fieldType = fieldType;
        this.elementType = elementType;
        this.valueType = valueType;
        this.rowSchema = rowSchema;
        this.isNullable = isNullable;
        this.isOptional = isOptional;
    }

    public static SqlFieldSchema createPrimitiveSchema(SamzaSqlFieldType typeName, boolean isNullable, boolean isOptional) {
        return new SqlFieldSchema(typeName, null, null, null, isNullable, isOptional);
    }

    public static SqlFieldSchema createArraySchema(SqlFieldSchema elementType, boolean isNullable, boolean isOptional) {
        return new SqlFieldSchema(SamzaSqlFieldType.ARRAY, elementType, null, null, isNullable, isOptional);
    }

    public static SqlFieldSchema createMapSchema(SqlFieldSchema valueType, boolean isNullable, boolean isOptional) {
        return new SqlFieldSchema(SamzaSqlFieldType.MAP, null, valueType, null, isNullable, isOptional);
    }

    public static SqlFieldSchema createRowFieldSchema(SqlSchema rowSchema, boolean isNullable, boolean isOptional) {
        return new SqlFieldSchema(SamzaSqlFieldType.ROW, null, null, rowSchema, isNullable, isOptional);
    }

    public boolean isPrimitiveField() {
        return this.fieldType != SamzaSqlFieldType.ARRAY && this.fieldType != SamzaSqlFieldType.MAP && this.fieldType != SamzaSqlFieldType.ROW;
    }

    public SamzaSqlFieldType getFieldType() {
        return this.fieldType;
    }

    public SqlFieldSchema getElementSchema() {
        return this.elementType;
    }

    public SqlFieldSchema getValueSchema() {
        return this.valueType;
    }

    public SqlSchema getRowSchema() {
        return this.rowSchema;
    }

    public boolean isNullable() {
        return this.isNullable;
    }

    public boolean isOptional() {
        return this.isOptional;
    }
}

