/*
 * Decompiled with CFR 0.152.
 */
package org.apache.samza.sql.schema;

import java.util.List;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import org.apache.samza.sql.schema.SqlFieldSchema;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SqlSchema {
    private static final Logger LOG = LoggerFactory.getLogger(SqlSchema.class);
    private List<SqlField> fields;

    public SqlSchema(List<String> colNames, List<SqlFieldSchema> colTypes) {
        if (colNames == null || colTypes == null || colNames.size() != colTypes.size()) {
            throw new IllegalArgumentException();
        }
        this.fields = IntStream.range(0, colTypes.size()).mapToObj(i -> new SqlField(i, (String)colNames.get(i), (SqlFieldSchema)colTypes.get(i))).collect(Collectors.toList());
    }

    public boolean containsField(String keyName) {
        return this.fields.stream().anyMatch(x -> x.getFieldName().equals(keyName));
    }

    public List<SqlField> getFields() {
        return this.fields;
    }

    public static class SqlField {
        private String fieldName;
        private SqlFieldSchema fieldSchema;
        private int position;

        public SqlField(int pos, String name, SqlFieldSchema schema) {
            this.position = pos;
            this.fieldName = name;
            this.fieldSchema = schema;
        }

        public int getPosition() {
            return this.position;
        }

        public void setPosition(int position) {
            this.position = position;
        }

        public String getFieldName() {
            return this.fieldName;
        }

        public void setFieldName(String fieldName) {
            this.fieldName = fieldName;
        }

        public SqlFieldSchema getFieldSchema() {
            return this.fieldSchema;
        }

        public void setFieldSchema(SqlFieldSchema fieldSchema) {
            this.fieldSchema = fieldSchema;
        }
    }
}

