/*
 * Decompiled with CFR 0.152.
 */
package org.apache.samza.storage.kv;

import java.nio.file.Path;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import org.apache.samza.annotation.InterfaceStability;
import org.apache.samza.checkpoint.CheckpointId;
import org.apache.samza.storage.kv.Entry;
import org.apache.samza.storage.kv.KeyValueIterator;
import org.apache.samza.storage.kv.KeyValueSnapshot;

public interface KeyValueStore<K, V> {
    public V get(K var1);

    default public Map<K, V> getAll(List<K> keys) {
        HashMap<K, V> map = new HashMap<K, V>(keys.size());
        for (K key : keys) {
            V value = this.get(key);
            if (value == null) continue;
            map.put(key, value);
        }
        return map;
    }

    public void put(K var1, V var2);

    public void putAll(List<Entry<K, V>> var1);

    public void delete(K var1);

    default public void deleteAll(List<K> keys) {
        for (K key : keys) {
            this.delete(key);
        }
    }

    public KeyValueIterator<K, V> range(K var1, K var2);

    default public KeyValueSnapshot<K, V> snapshot(K from, K to) {
        throw new UnsupportedOperationException("snapshot() is not supported in " + this.getClass().getName());
    }

    public KeyValueIterator<K, V> all();

    public void close();

    public void flush();

    @InterfaceStability.Unstable
    public Optional<Path> checkpoint(CheckpointId var1);
}

