/*
 * Decompiled with CFR 0.152.
 */
package org.apache.samza.system;

import org.apache.samza.Partition;
import org.apache.samza.system.SystemStream;

public class SystemStreamPartition
extends SystemStream
implements Comparable<SystemStreamPartition> {
    protected final Partition partition;
    protected final int hash;

    public SystemStreamPartition(String system, String stream, Partition partition) {
        super(system, stream);
        this.partition = partition;
        this.hash = this.computeHashCode();
    }

    public SystemStreamPartition(SystemStreamPartition other) {
        this(other.getSystem(), other.getStream(), other.getPartition());
    }

    public SystemStreamPartition(SystemStream other, Partition partition) {
        this(other.getSystem(), other.getStream(), partition);
    }

    public Partition getPartition() {
        return this.partition;
    }

    public SystemStream getSystemStream() {
        return new SystemStream(this.system, this.stream);
    }

    @Override
    public int hashCode() {
        return this.hash;
    }

    private int computeHashCode() {
        int prime = 31;
        int result = super.hashCode();
        result = 31 * result + (this.partition == null ? 0 : this.partition.hashCode());
        return result;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!super.equals(obj)) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        SystemStreamPartition other = (SystemStreamPartition)obj;
        return !(this.partition == null ? other.partition != null : !this.partition.equals(other.partition));
    }

    @Override
    public String toString() {
        return "SystemStreamPartition [" + this.system + ", " + this.stream + ", " + this.partition.getPartitionId() + "]";
    }

    @Override
    public int compareTo(SystemStreamPartition that) {
        if (this.system.compareTo(that.system) < 0) {
            return -1;
        }
        if (this.system.compareTo(that.system) > 0) {
            return 1;
        }
        if (this.stream.compareTo(that.stream) < 0) {
            return -1;
        }
        if (this.stream.compareTo(that.stream) > 0) {
            return 1;
        }
        if (this.partition.compareTo(that.partition) < 0) {
            return -1;
        }
        if (this.partition.compareTo(that.partition) > 0) {
            return 1;
        }
        return 0;
    }
}

