/*
 * Decompiled with CFR 0.152.
 */
package org.apache.samza.table.descriptors;

import com.google.common.base.Preconditions;
import java.time.Duration;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.samza.config.Config;
import org.apache.samza.table.descriptors.HybridTableDescriptor;
import org.apache.samza.table.descriptors.TableDescriptor;

public class CachingTableDescriptor<K, V>
extends HybridTableDescriptor<K, V, CachingTableDescriptor<K, V>> {
    public static final String PROVIDER_FACTORY_CLASS_NAME = "org.apache.samza.table.caching.CachingTableProviderFactory";
    public static final String REAL_TABLE_ID = "realTableId";
    public static final String CACHE_TABLE_ID = "cacheTableId";
    public static final String READ_TTL_MS = "readTtl";
    public static final String WRITE_TTL_MS = "writeTtl";
    public static final String CACHE_SIZE = "cacheSize";
    public static final String WRITE_AROUND = "writeAround";
    private Duration readTtl;
    private Duration writeTtl;
    private long cacheSize;
    private TableDescriptor<K, V, ?> cache;
    private TableDescriptor<K, V, ?> table;
    private boolean isWriteAround;

    public CachingTableDescriptor(String tableId, TableDescriptor<K, V, ?> table) {
        super(tableId);
        this.table = table;
    }

    public CachingTableDescriptor(String tableId, TableDescriptor<K, V, ?> table, TableDescriptor<K, V, ?> cache) {
        this(tableId, table);
        this.cache = cache;
    }

    @Override
    public List<? extends TableDescriptor<K, V, ?>> getTableDescriptors() {
        return this.cache != null ? Arrays.asList(this.cache, this.table) : Arrays.asList(this.table);
    }

    public CachingTableDescriptor<K, V> withReadTtl(Duration readTtl) {
        this.readTtl = readTtl;
        return this;
    }

    public CachingTableDescriptor<K, V> withWriteTtl(Duration writeTtl) {
        this.writeTtl = writeTtl;
        return this;
    }

    public CachingTableDescriptor<K, V> withCacheSize(long cacheSize) {
        this.cacheSize = cacheSize;
        return this;
    }

    public CachingTableDescriptor<K, V> withWriteAround() {
        this.isWriteAround = true;
        return this;
    }

    @Override
    public String getProviderFactoryClassName() {
        return PROVIDER_FACTORY_CLASS_NAME;
    }

    @Override
    public Map<String, String> toConfig(Config jobConfig) {
        HashMap<String, String> tableConfig = new HashMap<String, String>(super.toConfig(jobConfig));
        if (this.cache != null) {
            this.addTableConfig(CACHE_TABLE_ID, this.cache.getTableId(), tableConfig);
        } else {
            if (this.readTtl != null) {
                this.addTableConfig(READ_TTL_MS, String.valueOf(this.readTtl.toMillis()), tableConfig);
            }
            if (this.writeTtl != null) {
                this.addTableConfig(WRITE_TTL_MS, String.valueOf(this.writeTtl.toMillis()), tableConfig);
            }
            if (this.cacheSize > 0L) {
                this.addTableConfig(CACHE_SIZE, String.valueOf(this.cacheSize), tableConfig);
            }
        }
        this.addTableConfig(REAL_TABLE_ID, this.table.getTableId(), tableConfig);
        this.addTableConfig(WRITE_AROUND, String.valueOf(this.isWriteAround), tableConfig);
        return Collections.unmodifiableMap(tableConfig);
    }

    @Override
    protected void validate() {
        Preconditions.checkNotNull(this.table, (Object)"Actual table is required.");
        if (this.cache == null) {
            Preconditions.checkNotNull((Object)this.readTtl, (Object)"readTtl must be specified.");
        } else {
            Preconditions.checkArgument((this.readTtl == null && this.writeTtl == null && this.cacheSize == 0L ? 1 : 0) != 0, (Object)"Invalid to specify both {cache} and {readTtl|writeTtl|cacheSize} at the same time.");
        }
    }
}

