/*
 * Decompiled with CFR 0.152.
 */
package org.apache.samza.table.descriptors;

import com.google.common.base.Preconditions;
import java.lang.reflect.Constructor;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import org.apache.samza.SamzaException;
import org.apache.samza.config.Config;
import org.apache.samza.config.MapConfig;
import org.apache.samza.table.batching.BatchProvider;
import org.apache.samza.table.descriptors.BaseTableDescriptor;
import org.apache.samza.table.remote.TablePart;
import org.apache.samza.table.remote.TableRateLimiter;
import org.apache.samza.table.remote.TableReadFunction;
import org.apache.samza.table.remote.TableWriteFunction;
import org.apache.samza.table.retry.TableRetryPolicy;
import org.apache.samza.table.utils.SerdeUtils;
import org.apache.samza.util.RateLimiter;

public class RemoteTableDescriptor<K, V>
extends BaseTableDescriptor<K, V, RemoteTableDescriptor<K, V>> {
    public static final String PROVIDER_FACTORY_CLASS_NAME = "org.apache.samza.table.remote.RemoteTableProviderFactory";
    public static final String DEFAULT_RATE_LIMITER_CLASS_NAME = "org.apache.samza.util.EmbeddedTaggedRateLimiter";
    public static final String RL_READ_TAG = "readTag";
    public static final String RL_WRITE_TAG = "writeTag";
    public static final String READ_FN = "io.read.func";
    public static final String WRITE_FN = "io.write.func";
    public static final String RATE_LIMITER = "io.ratelimiter";
    public static final String READ_CREDIT_FN = "io.read.credit.func";
    public static final String WRITE_CREDIT_FN = "io.write.credit.func";
    public static final String ASYNC_CALLBACK_POOL_SIZE = "io.async.callback.pool.size";
    public static final String READ_RETRY_POLICY = "io.read.retry.policy";
    public static final String WRITE_RETRY_POLICY = "io.write.retry.policy";
    public static final String BATCH_PROVIDER = "io.batch.provider";
    private TableReadFunction<K, V> readFn;
    private TableWriteFunction<K, V> writeFn;
    private RateLimiter rateLimiter;
    private boolean enableReadRateLimiter = true;
    private boolean enableWriteRateLimiter = true;
    private BatchProvider<K, V> batchProvider;
    private Map<String, Integer> tagCreditsMap = new HashMap<String, Integer>();
    private TableRateLimiter.CreditFunction<K, V> readCreditFn;
    private TableRateLimiter.CreditFunction<K, V> writeCreditFn;
    private TableRetryPolicy readRetryPolicy;
    private TableRetryPolicy writeRetryPolicy;
    private int asyncCallbackPoolSize = -1;

    public RemoteTableDescriptor(String tableId) {
        super(tableId);
    }

    public RemoteTableDescriptor<K, V> withReadFunction(TableReadFunction<K, V> readFn) {
        Preconditions.checkNotNull(readFn, (Object)"null read function");
        this.readFn = readFn;
        return this;
    }

    public RemoteTableDescriptor<K, V> withWriteFunction(TableWriteFunction<K, V> writeFn) {
        Preconditions.checkNotNull(writeFn, (Object)"null write function");
        this.writeFn = writeFn;
        return this;
    }

    public RemoteTableDescriptor<K, V> withReadRetryPolicy(TableRetryPolicy retryPolicy) {
        Preconditions.checkNotNull(this.readFn, (Object)"null read function");
        Preconditions.checkNotNull((Object)retryPolicy, (Object)"null retry policy");
        this.readRetryPolicy = retryPolicy;
        return this;
    }

    public RemoteTableDescriptor<K, V> withWriteRetryPolicy(TableRetryPolicy retryPolicy) {
        Preconditions.checkNotNull(this.writeFn, (Object)"null write function");
        Preconditions.checkNotNull((Object)retryPolicy, (Object)"null retry policy");
        this.writeRetryPolicy = retryPolicy;
        return this;
    }

    public RemoteTableDescriptor<K, V> withRateLimiter(RateLimiter rateLimiter, TableRateLimiter.CreditFunction<K, V> readCreditFn, TableRateLimiter.CreditFunction<K, V> writeCreditFn) {
        Preconditions.checkNotNull((Object)rateLimiter, (Object)"null read rate limiter");
        this.rateLimiter = rateLimiter;
        this.readCreditFn = readCreditFn;
        this.writeCreditFn = writeCreditFn;
        return this;
    }

    public RemoteTableDescriptor<K, V> withRateLimiterDisabled() {
        this.withReadRateLimiterDisabled();
        this.withWriteRateLimiterDisabled();
        return this;
    }

    public RemoteTableDescriptor<K, V> withReadRateLimiterDisabled() {
        this.enableReadRateLimiter = false;
        return this;
    }

    public RemoteTableDescriptor<K, V> withWriteRateLimiterDisabled() {
        this.enableWriteRateLimiter = false;
        return this;
    }

    public RemoteTableDescriptor<K, V> withReadRateLimit(int creditsPerSec) {
        Preconditions.checkArgument((creditsPerSec > 0 ? 1 : 0) != 0, (Object)"Max read rate must be a positive number.");
        this.tagCreditsMap.put(RL_READ_TAG, creditsPerSec);
        return this;
    }

    public RemoteTableDescriptor<K, V> withWriteRateLimit(int creditsPerSec) {
        Preconditions.checkArgument((creditsPerSec > 0 ? 1 : 0) != 0, (Object)"Max write rate must be a positive number.");
        this.tagCreditsMap.put(RL_WRITE_TAG, creditsPerSec);
        return this;
    }

    public RemoteTableDescriptor<K, V> withAsyncCallbackExecutorPoolSize(int poolSize) {
        this.asyncCallbackPoolSize = poolSize;
        return this;
    }

    public RemoteTableDescriptor<K, V> withBatchProvider(BatchProvider<K, V> batchProvider) {
        this.batchProvider = batchProvider;
        return this;
    }

    @Override
    public String getProviderFactoryClassName() {
        return PROVIDER_FACTORY_CLASS_NAME;
    }

    @Override
    public Map<String, String> toConfig(Config jobConfig) {
        HashMap<String, String> tableConfig = new HashMap<String, String>(super.toConfig(jobConfig));
        if (!this.tagCreditsMap.isEmpty()) {
            RateLimiter defaultRateLimiter;
            try {
                Class<?> clazz = Class.forName(DEFAULT_RATE_LIMITER_CLASS_NAME);
                Constructor<?> ctor = clazz.getConstructor(Map.class);
                defaultRateLimiter = (RateLimiter)ctor.newInstance(this.tagCreditsMap);
            }
            catch (Exception ex) {
                throw new SamzaException("Failed to create default rate limiter", ex);
            }
            this.addTableConfig(RATE_LIMITER, SerdeUtils.serialize("rate limiter", defaultRateLimiter), tableConfig);
            if (defaultRateLimiter instanceof TablePart) {
                this.addTablePartConfig(RATE_LIMITER, (TablePart)((Object)defaultRateLimiter), jobConfig, tableConfig);
            }
        } else if (this.rateLimiter != null) {
            this.addTableConfig(RATE_LIMITER, SerdeUtils.serialize("rate limiter", this.rateLimiter), tableConfig);
            if (this.rateLimiter instanceof TablePart) {
                this.addTablePartConfig(RATE_LIMITER, (TablePart)((Object)this.rateLimiter), jobConfig, tableConfig);
            }
        }
        if (this.readCreditFn != null) {
            this.addTableConfig(READ_CREDIT_FN, SerdeUtils.serialize("read credit function", this.readCreditFn), tableConfig);
            this.addTablePartConfig(READ_CREDIT_FN, this.readCreditFn, jobConfig, tableConfig);
        }
        if (this.writeCreditFn != null) {
            this.addTableConfig(WRITE_CREDIT_FN, SerdeUtils.serialize("write credit function", this.writeCreditFn), tableConfig);
            this.addTablePartConfig(WRITE_CREDIT_FN, this.writeCreditFn, jobConfig, tableConfig);
        }
        if (this.readRetryPolicy != null) {
            this.addTableConfig(READ_RETRY_POLICY, SerdeUtils.serialize("read retry policy", this.readRetryPolicy), tableConfig);
            this.addTablePartConfig(READ_RETRY_POLICY, this.readRetryPolicy, jobConfig, tableConfig);
        }
        if (this.writeRetryPolicy != null) {
            this.addTableConfig(WRITE_RETRY_POLICY, SerdeUtils.serialize("write retry policy", this.writeRetryPolicy), tableConfig);
            this.addTablePartConfig(WRITE_RETRY_POLICY, this.writeRetryPolicy, jobConfig, tableConfig);
        }
        this.addTableConfig(ASYNC_CALLBACK_POOL_SIZE, String.valueOf(this.asyncCallbackPoolSize), tableConfig);
        if (this.readFn != null) {
            this.addTableConfig(READ_FN, SerdeUtils.serialize("read function", this.readFn), tableConfig);
            this.addTablePartConfig(READ_FN, this.readFn, jobConfig, tableConfig);
        }
        if (this.writeFn != null) {
            this.addTableConfig(WRITE_FN, SerdeUtils.serialize("write function", this.writeFn), tableConfig);
            this.addTablePartConfig(WRITE_FN, this.writeFn, jobConfig, tableConfig);
        }
        if (this.batchProvider != null) {
            this.addTableConfig(BATCH_PROVIDER, SerdeUtils.serialize("batch provider", this.batchProvider), tableConfig);
            this.addTablePartConfig(BATCH_PROVIDER, this.batchProvider, jobConfig, tableConfig);
        }
        return Collections.unmodifiableMap(tableConfig);
    }

    @Override
    protected void validate() {
        Preconditions.checkArgument((this.writeFn != null || this.readFn != null ? 1 : 0) != 0, (Object)"Must have one of TableReadFunction or TableWriteFunction");
        Preconditions.checkArgument((this.rateLimiter == null || this.tagCreditsMap.isEmpty() ? 1 : 0) != 0, (Object)"Only one of rateLimiter instance or read/write limits can be specified");
        Preconditions.checkArgument((this.asyncCallbackPoolSize <= 20 ? 1 : 0) != 0, (Object)"too many threads for async callback executor.");
        if (this.readFn != null && this.enableReadRateLimiter) {
            Preconditions.checkArgument((this.readCreditFn != null || this.tagCreditsMap.containsKey(RL_READ_TAG) ? 1 : 0) != 0, (Object)"Read rate limiter is enabled, there is no read rate limiter configured.");
        }
        if (this.writeFn != null && this.enableWriteRateLimiter) {
            Preconditions.checkArgument((this.writeCreditFn != null || this.tagCreditsMap.containsKey(RL_WRITE_TAG) ? 1 : 0) != 0, (Object)"Write rate limiter is enabled, there is no write rate limiter configured.");
        }
    }

    protected void addTablePartConfig(String tablePartKey, TablePart tablePart, Config jobConfig, Map<String, String> tableConfig) {
        tablePart.toConfig(jobConfig, new MapConfig(tableConfig)).forEach((k, v) -> this.addTableConfig(String.format("%s.%s", tablePartKey, k), (String)v, tableConfig));
    }
}

