/*
 * Decompiled with CFR 0.152.
 */
package org.apache.samza.table.retry;

import com.google.common.base.Preconditions;
import java.io.Serializable;
import java.time.Duration;
import java.util.Collections;
import java.util.Map;
import java.util.function.Predicate;
import org.apache.samza.config.Config;
import org.apache.samza.table.remote.TablePart;
import org.apache.samza.table.utils.SerdeUtils;

public class TableRetryPolicy
implements TablePart,
Serializable {
    private Duration sleepTime;
    private Duration randomMin;
    private Duration randomMax;
    private double exponentialFactor;
    private Duration exponentialMaxSleep;
    private Duration jitter;
    private Integer maxAttempts = null;
    private Duration maxDuration = null;
    private BackoffType backoffType = BackoffType.NONE;
    private RetryPredicate retryPredicate = ex -> false;

    public TableRetryPolicy withFixedBackoff(Duration sleepTime) {
        Preconditions.checkNotNull((Object)sleepTime);
        this.sleepTime = sleepTime;
        this.backoffType = BackoffType.FIXED;
        return this;
    }

    public TableRetryPolicy withRandomBackoff(Duration minSleep, Duration maxSleep) {
        Preconditions.checkNotNull((Object)minSleep);
        Preconditions.checkNotNull((Object)maxSleep);
        this.randomMin = minSleep;
        this.randomMax = maxSleep;
        this.backoffType = BackoffType.RANDOM;
        return this;
    }

    public TableRetryPolicy withExponentialBackoff(Duration sleepTime, Duration maxSleep, double factor) {
        Preconditions.checkNotNull((Object)sleepTime);
        Preconditions.checkNotNull((Object)maxSleep);
        this.sleepTime = sleepTime;
        this.exponentialMaxSleep = maxSleep;
        this.exponentialFactor = factor;
        this.backoffType = BackoffType.EXPONENTIAL;
        return this;
    }

    public TableRetryPolicy withJitter(Duration jitter) {
        Preconditions.checkNotNull((Object)jitter);
        if (this.backoffType != BackoffType.RANDOM) {
            this.jitter = jitter;
        }
        return this;
    }

    public TableRetryPolicy withStopAfterAttempts(int maxAttempts) {
        Preconditions.checkArgument((maxAttempts >= 0 ? 1 : 0) != 0);
        this.maxAttempts = maxAttempts;
        return this;
    }

    public TableRetryPolicy withStopAfterDelay(Duration maxDelay) {
        Preconditions.checkNotNull((Object)maxDelay);
        this.maxDuration = maxDelay;
        return this;
    }

    public TableRetryPolicy withRetryPredicate(RetryPredicate retryPredicate) {
        Preconditions.checkNotNull((Object)retryPredicate);
        this.retryPredicate = retryPredicate;
        return this;
    }

    public Duration getSleepTime() {
        return this.sleepTime;
    }

    public Duration getRandomMin() {
        return this.randomMin;
    }

    public Duration getRandomMax() {
        return this.randomMax;
    }

    public double getExponentialFactor() {
        return this.exponentialFactor;
    }

    public Duration getExponentialMaxSleep() {
        return this.exponentialMaxSleep;
    }

    public Duration getJitter() {
        return this.jitter;
    }

    public Integer getMaxAttempts() {
        return this.maxAttempts;
    }

    public Duration getMaxDuration() {
        return this.maxDuration;
    }

    public BackoffType getBackoffType() {
        return this.backoffType;
    }

    public RetryPredicate getRetryPredicate() {
        return this.retryPredicate;
    }

    @Override
    public Map<String, String> toConfig(Config jobConfig, Config tableConfig) {
        return Collections.singletonMap(this.getClass().getSimpleName(), SerdeUtils.toJson("table retry policy", this));
    }

    public static interface RetryPredicate
    extends Predicate<Throwable>,
    Serializable {
    }

    static enum BackoffType {
        NONE,
        FIXED,
        RANDOM,
        EXPONENTIAL;

    }
}

