/*
 * Decompiled with CFR 0.152.
 */
package org.apache.samza.config;

import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import org.apache.samza.config.Config;
import org.apache.samza.config.MapConfig;

public class JavaTableConfig
extends MapConfig {
    public static final String TABLES_PREFIX = "tables.";
    public static final String TABLE_ID_PREFIX = "tables.%s";
    public static final String TABLE_PROVIDER_FACTORY_SUFFIX = ".provider.factory";
    public static final String TABLE_PROVIDER_FACTORY = String.format("%s.provider.factory", "tables.%s");
    public static final String STORE_KEY_SERDE = "stores.%s.key.serde";
    public static final String STORE_MSG_SERDE = "stores.%s.msg.serde";

    public JavaTableConfig(Map<String, String> config) {
        super(config);
    }

    public List<String> getTableIds() {
        Config subConfig = this.subset(TABLES_PREFIX, true);
        Set tableNames = subConfig.keySet().stream().filter(k -> k.endsWith(TABLE_PROVIDER_FACTORY_SUFFIX)).map(k -> k.replace(TABLE_PROVIDER_FACTORY_SUFFIX, "")).collect(Collectors.toSet());
        return new LinkedList<String>(tableNames);
    }

    public String getTableProviderFactory(String tableId) {
        return this.get(String.format(TABLE_PROVIDER_FACTORY, tableId), null);
    }

    public String getKeySerde(String tableId) {
        return this.get(String.format(STORE_KEY_SERDE, tableId), null);
    }

    public String getMsgSerde(String tableId) {
        return this.get(String.format(STORE_MSG_SERDE, tableId), null);
    }

    public String getForTable(String tableId, String key, String defaultValue) {
        return this.get(JavaTableConfig.buildKey(tableId, key), defaultValue);
    }

    public String getForTable(String tableId, String key) {
        return this.getForTable(tableId, key, null);
    }

    public static String buildKey(String tableId, String key) {
        return String.format("tables.%s.%s", tableId, key);
    }
}

