/*
 * Decompiled with CFR 0.152.
 */
package org.apache.samza.container.placement;

import com.google.common.base.Preconditions;
import java.time.Duration;
import java.util.Objects;
import java.util.UUID;

public abstract class ContainerPlacementMessage {
    protected final UUID uuid;
    protected final String deploymentId;
    protected final String processorId;
    protected final String destinationHost;
    protected final Duration requestExpiry;
    protected final StatusCode statusCode;
    protected final long timestamp;

    protected ContainerPlacementMessage(UUID uuid, String deploymentId, String processorId, String destinationHost, Duration requestExpiry, StatusCode statusCode, long timestamp) {
        this.uuid = (UUID)Preconditions.checkNotNull((Object)uuid, (Object)"uuid cannot be null");
        this.deploymentId = (String)Preconditions.checkNotNull((Object)deploymentId, (Object)"deploymentId cannot be null");
        this.processorId = (String)Preconditions.checkNotNull((Object)processorId, (Object)"processorId cannot be null");
        this.destinationHost = (String)Preconditions.checkNotNull((Object)destinationHost, (Object)"destinationHost cannot be null");
        this.statusCode = (StatusCode)((Object)Preconditions.checkNotNull((Object)((Object)statusCode), (Object)"statusCode cannot be null"));
        this.timestamp = (Long)Preconditions.checkNotNull((Object)timestamp, (Object)"Timestamp of the message cannot be null");
        this.requestExpiry = requestExpiry;
    }

    protected ContainerPlacementMessage(UUID uuid, String deploymentId, String processorId, String destinationHost, StatusCode statusCode, long timestamp) {
        this(uuid, deploymentId, processorId, destinationHost, null, statusCode, timestamp);
    }

    public String getDeploymentId() {
        return this.deploymentId;
    }

    public String getProcessorId() {
        return this.processorId;
    }

    public String getDestinationHost() {
        return this.destinationHost;
    }

    public StatusCode getStatusCode() {
        return this.statusCode;
    }

    public Duration getRequestExpiry() {
        return this.requestExpiry;
    }

    public UUID getUuid() {
        return this.uuid;
    }

    public long getTimestamp() {
        return this.timestamp;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ContainerPlacementMessage message = (ContainerPlacementMessage)o;
        return this.getTimestamp() == message.getTimestamp() && this.getUuid().equals(message.getUuid()) && this.getDeploymentId().equals(message.getDeploymentId()) && this.getProcessorId().equals(message.getProcessorId()) && this.getDestinationHost().equals(message.getDestinationHost()) && Objects.equals(this.getRequestExpiry(), message.getRequestExpiry()) && this.getStatusCode() == message.getStatusCode();
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.getUuid(), this.getDeploymentId(), this.getProcessorId(), this.getDestinationHost(), this.getRequestExpiry(), this.getStatusCode(), this.getTimestamp()});
    }

    public static enum StatusCode {
        CREATED,
        BAD_REQUEST,
        ACCEPTED,
        IN_PROGRESS,
        SUCCEEDED,
        FAILED;

    }
}

