/*
 * Decompiled with CFR 0.152.
 */
package org.apache.samza.job;

import com.google.common.base.Preconditions;
import java.util.Objects;
import org.apache.commons.lang3.StringUtils;
import org.apache.samza.annotation.InterfaceStability;

@InterfaceStability.Unstable
public class JobCoordinatorMetadata {
    private final String configId;
    private final String epochId;
    private final String jobModelId;

    public JobCoordinatorMetadata(String epochId, String configId, String jobModelId) {
        Preconditions.checkState((boolean)StringUtils.isNotBlank((CharSequence)epochId), (Object)"Epoch ID cannot be empty");
        Preconditions.checkState((boolean)StringUtils.isNotBlank((CharSequence)configId), (Object)"Config ID cannot be empty");
        Preconditions.checkState((boolean)StringUtils.isNotBlank((CharSequence)jobModelId), (Object)"Job Model ID cannot be empty");
        this.configId = configId;
        this.epochId = epochId;
        this.jobModelId = jobModelId;
    }

    public String getConfigId() {
        return this.configId;
    }

    public String getEpochId() {
        return this.epochId;
    }

    public String getJobModelId() {
        return this.jobModelId;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof JobCoordinatorMetadata)) {
            return false;
        }
        JobCoordinatorMetadata metadata = (JobCoordinatorMetadata)o;
        return Objects.equals(this.configId, metadata.configId) && Objects.equals(this.epochId, metadata.epochId) && Objects.equals(this.jobModelId, metadata.jobModelId);
    }

    public int hashCode() {
        return Objects.hash(this.configId, this.epochId, this.jobModelId);
    }

    public String toString() {
        return "JobCoordinatorMetadata{configId='" + this.configId + '\'' + ", epochId='" + this.epochId + '\'' + ", jobModelId='" + this.jobModelId + '\'' + '}';
    }
}

