/*
 * Decompiled with CFR 0.152.
 */
package org.apache.samza.job.model;

import java.util.Collections;
import java.util.Map;
import org.apache.samza.config.Config;
import org.apache.samza.job.model.ContainerModel;
import org.apache.samza.job.model.TaskModel;

public class JobModel {
    private final Config config;
    private final Map<String, ContainerModel> containers;
    public int maxChangeLogStreamPartitions;

    public JobModel(Config config, Map<String, ContainerModel> containers) {
        this.config = config;
        this.containers = Collections.unmodifiableMap(containers);
        this.maxChangeLogStreamPartitions = 0;
        for (ContainerModel container : containers.values()) {
            for (TaskModel task : container.getTasks().values()) {
                if (this.maxChangeLogStreamPartitions >= task.getChangelogPartition().getPartitionId() + 1) continue;
                this.maxChangeLogStreamPartitions = task.getChangelogPartition().getPartitionId() + 1;
            }
        }
    }

    public Config getConfig() {
        return this.config;
    }

    public Map<String, ContainerModel> getContainers() {
        return this.containers;
    }

    public String toString() {
        return "JobModel [config=" + this.config + ", containers=" + this.containers + "]";
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.config == null ? 0 : this.config.hashCode());
        result = 31 * result + (this.containers == null ? 0 : this.containers.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        JobModel other = (JobModel)obj;
        if (this.config == null ? other.config != null : !this.config.equals(other.config)) {
            return false;
        }
        return !(this.containers == null ? other.containers != null : !this.containers.equals(other.containers));
    }
}

