/*
 * Decompiled with CFR 0.152.
 */
package org.apache.samza.job.model;

import java.util.Collections;
import java.util.Set;
import org.apache.samza.Partition;
import org.apache.samza.container.TaskName;
import org.apache.samza.job.model.TaskMode;
import org.apache.samza.system.SystemStreamPartition;

public class TaskModel
implements Comparable<TaskModel> {
    private final TaskName taskName;
    private final Set<SystemStreamPartition> systemStreamPartitions;
    private final Partition changelogPartition;
    private final TaskMode taskMode;

    public TaskModel(TaskName taskName, Set<SystemStreamPartition> systemStreamPartitions, Partition changelogPartition, TaskMode taskMode) {
        this.taskName = taskName;
        this.systemStreamPartitions = Collections.unmodifiableSet(systemStreamPartitions);
        this.changelogPartition = changelogPartition;
        this.taskMode = taskMode;
    }

    public TaskModel(TaskName taskName, Set<SystemStreamPartition> systemStreamPartitions, Partition changelogPartition) {
        this(taskName, systemStreamPartitions, changelogPartition, TaskMode.Active);
    }

    public TaskName getTaskName() {
        return this.taskName;
    }

    public Set<SystemStreamPartition> getSystemStreamPartitions() {
        return this.systemStreamPartitions;
    }

    public Partition getChangelogPartition() {
        return this.changelogPartition;
    }

    public TaskMode getTaskMode() {
        return this.taskMode;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        TaskModel taskModel = (TaskModel)o;
        if (!this.changelogPartition.equals(taskModel.changelogPartition)) {
            return false;
        }
        if (!this.systemStreamPartitions.equals(taskModel.systemStreamPartitions)) {
            return false;
        }
        if (!this.taskName.equals(taskModel.taskName)) {
            return false;
        }
        return this.taskMode.equals((Object)taskModel.taskMode);
    }

    public int hashCode() {
        int result = this.taskName.hashCode();
        result = 31 * result + this.systemStreamPartitions.hashCode();
        result = 31 * result + this.changelogPartition.hashCode();
        result = 31 * result + this.taskMode.hashCode();
        return result;
    }

    public String toString() {
        return "TaskModel [taskName=" + this.taskName + ", systemStreamPartitions=" + this.systemStreamPartitions + ", changeLogPartition=" + this.changelogPartition + ", taskMode=" + (Object)((Object)this.taskMode) + "]";
    }

    @Override
    public int compareTo(TaskModel other) {
        return this.taskName.compareTo(other.getTaskName());
    }
}

