/*
 * Decompiled with CFR 0.152.
 */
package org.apache.samza.metrics;

import java.util.concurrent.atomic.AtomicReference;
import org.apache.samza.metrics.Metric;
import org.apache.samza.metrics.MetricsVisitor;

public class Gauge<T>
implements Metric {
    private final String name;
    private AtomicReference<T> ref;

    public Gauge(String name, T value) {
        this.name = name;
        this.ref = new AtomicReference<T>(value);
    }

    public boolean compareAndSet(T expected, T n) {
        return this.ref.compareAndSet(expected, n);
    }

    public T set(T n) {
        return this.ref.getAndSet(n);
    }

    public T getValue() {
        return this.ref.get();
    }

    public String getName() {
        return this.name;
    }

    @Override
    public void visit(MetricsVisitor visitor) {
        visitor.gauge(this);
    }

    public String toString() {
        T value = this.ref.get();
        return value == null ? null : value.toString();
    }
}

