/*
 * Decompiled with CFR 0.152.
 */
package org.apache.samza.metrics;

import java.util.ArrayList;
import java.util.Collection;

public class Snapshot {
    private final ArrayList<Long> values;
    private final long min;
    private final long max;
    private final double sum;
    private final int size;

    Snapshot(Collection<Long> values) {
        this.values = new ArrayList(values.size());
        long max = Long.MIN_VALUE;
        long min = Long.MAX_VALUE;
        double sum = 0.0;
        for (Long value : values) {
            sum += (double)value.longValue();
            this.values.add(value);
            if (value > max) {
                max = value;
            }
            if (value >= min) continue;
            min = value;
        }
        this.sum = sum;
        this.size = this.values.size();
        if (this.size == 0) {
            this.max = 0L;
            this.min = 0L;
        } else {
            this.max = max;
            this.min = min;
        }
    }

    public long getMax() {
        return this.max;
    }

    public long getMin() {
        return this.min;
    }

    public double getAverage() {
        return this.size == 0 ? 0.0 : this.sum / (double)this.size;
    }

    public double getSum() {
        return this.sum;
    }

    public int getSize() {
        return this.size;
    }

    public ArrayList<Long> getValues() {
        return (ArrayList)this.values.clone();
    }
}

