/*
 * Decompiled with CFR 0.152.
 */
package org.apache.samza.operators.triggers;

import java.time.Duration;
import java.util.ArrayList;
import java.util.Collections;
import org.apache.samza.annotation.InterfaceStability;
import org.apache.samza.operators.triggers.AnyTrigger;
import org.apache.samza.operators.triggers.CountTrigger;
import org.apache.samza.operators.triggers.RepeatingTrigger;
import org.apache.samza.operators.triggers.TimeSinceFirstMessageTrigger;
import org.apache.samza.operators.triggers.TimeSinceLastMessageTrigger;
import org.apache.samza.operators.triggers.Trigger;

@InterfaceStability.Unstable
public final class Triggers {
    private Triggers() {
    }

    public static <M> Trigger<M> count(long count) {
        return new CountTrigger(count);
    }

    public static <M> Trigger<M> timeSinceFirstMessage(Duration duration) {
        return new TimeSinceFirstMessageTrigger(duration);
    }

    public static <M> Trigger<M> timeSinceLastMessage(Duration duration) {
        return new TimeSinceLastMessageTrigger(duration);
    }

    public static <M> Trigger<M> any(Trigger<M> ... triggers) {
        ArrayList<Trigger<M>> triggerList = new ArrayList<Trigger<M>>();
        for (Trigger<M> trigger : triggers) {
            triggerList.add(trigger);
        }
        return new AnyTrigger(Collections.unmodifiableList(triggerList));
    }

    public static <M> Trigger<M> repeat(Trigger<M> trigger) {
        return new RepeatingTrigger<M>(trigger);
    }
}

