/*
 * Decompiled with CFR 0.152.
 */
package org.apache.samza.serializers;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import org.apache.samza.SamzaException;
import org.apache.samza.serializers.Serde;

public class SerializableSerde<T extends Serializable>
implements Serde<T> {
    @Override
    public byte[] toBytes(T obj) {
        if (obj != null) {
            ByteArrayOutputStream bos = new ByteArrayOutputStream();
            ObjectOutputStream oos = null;
            try {
                oos = new ObjectOutputStream(bos);
                oos.writeObject(obj);
            }
            catch (IOException e) {
                throw new SamzaException("Error writing to output stream", e);
            }
            finally {
                try {
                    if (oos != null) {
                        oos.close();
                    }
                }
                catch (IOException e) {
                    throw new SamzaException("Error closing output stream", e);
                }
            }
            return bos.toByteArray();
        }
        return null;
    }

    @Override
    public T fromBytes(byte[] bytes) {
        if (bytes != null) {
            ByteArrayInputStream bis = new ByteArrayInputStream(bytes);
            ObjectInputStream ois = null;
            try {
                ois = new ObjectInputStream(bis);
                Serializable serializable = (Serializable)ois.readObject();
                return (T)serializable;
            }
            catch (IOException | ClassNotFoundException e) {
                throw new SamzaException("Error reading from input stream.", e);
            }
            finally {
                try {
                    if (ois != null) {
                        ois.close();
                    }
                }
                catch (IOException e) {
                    throw new SamzaException("Error closing input stream", e);
                }
            }
        }
        return null;
    }
}

