/*
 * Decompiled with CFR 0.152.
 */
package org.apache.samza.serializers;

import java.nio.ByteBuffer;
import java.util.UUID;
import org.apache.samza.serializers.Serde;

public class UUIDSerde
implements Serde<UUID> {
    @Override
    public byte[] toBytes(UUID obj) {
        if (obj != null) {
            return ByteBuffer.allocate(16).putLong(obj.getMostSignificantBits()).putLong(obj.getLeastSignificantBits()).array();
        }
        return null;
    }

    @Override
    public UUID fromBytes(byte[] bytes) {
        if (bytes != null) {
            ByteBuffer buffer = ByteBuffer.wrap(bytes);
            return new UUID(buffer.getLong(), buffer.getLong());
        }
        return null;
    }
}

