/*
 * Decompiled with CFR 0.152.
 */
package org.apache.samza.sql.schema;

import java.util.ArrayList;
import java.util.List;
import org.apache.samza.sql.schema.SqlFieldSchema;
import org.apache.samza.sql.schema.SqlSchema;

public class SqlSchemaBuilder {
    private List<String> fieldNames = new ArrayList<String>();
    private List<SqlFieldSchema> fieldSchemas = new ArrayList<SqlFieldSchema>();

    private SqlSchemaBuilder() {
    }

    public static SqlSchemaBuilder builder() {
        return new SqlSchemaBuilder();
    }

    public SqlSchemaBuilder addField(String name, SqlFieldSchema fieldType) {
        if (name == null || name.isEmpty() || fieldType == null) {
            throw new IllegalArgumentException();
        }
        this.fieldNames.add(name);
        this.fieldSchemas.add(fieldType);
        return this;
    }

    public SqlSchema build() {
        return new SqlSchema(this.fieldNames, this.fieldSchemas);
    }
}

