/*
 * Decompiled with CFR 0.152.
 */
package org.apache.samza.startpoint;

import com.google.common.base.MoreObjects;
import com.google.common.base.Objects;
import java.time.Instant;
import org.apache.samza.annotation.InterfaceStability;
import org.apache.samza.startpoint.StartpointVisitor;
import org.codehaus.jackson.annotate.JsonTypeInfo;

@InterfaceStability.Evolving
@JsonTypeInfo(use=JsonTypeInfo.Id.NAME, include=JsonTypeInfo.As.PROPERTY, property="@type")
public abstract class Startpoint {
    private final long creationTimestamp;

    Startpoint() {
        this(Instant.now().toEpochMilli());
    }

    Startpoint(long creationTimestamp) {
        this.creationTimestamp = creationTimestamp;
    }

    public long getCreationTimestamp() {
        return this.creationTimestamp;
    }

    public abstract <IN, OUT> OUT apply(IN var1, StartpointVisitor<IN, OUT> var2);

    public String toString() {
        return MoreObjects.toStringHelper((Object)this).toString();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Startpoint that = (Startpoint)o;
        return Objects.equal((Object)this.creationTimestamp, (Object)that.creationTimestamp);
    }

    public int hashCode() {
        return Objects.hashCode((Object[])new Object[]{this.creationTimestamp});
    }
}

