/*
 * Decompiled with CFR 0.152.
 */
package org.apache.samza.system;

import org.apache.samza.system.BoundedSSPIterator;
import org.apache.samza.system.IncomingMessageEnvelope;
import org.apache.samza.system.SystemAdmin;
import org.apache.samza.system.SystemConsumer;
import org.apache.samza.system.SystemStreamPartition;

public class ChangelogSSPIterator
extends BoundedSSPIterator {
    private final String restoreOffset;
    private final boolean trimEnabled;
    private Mode mode = Mode.RESTORE;

    public ChangelogSSPIterator(SystemConsumer systemConsumer, SystemStreamPartition systemStreamPartition, String restoreOffset, SystemAdmin admin, boolean trimEnabled) {
        this(systemConsumer, systemStreamPartition, restoreOffset, admin, trimEnabled, null);
    }

    public ChangelogSSPIterator(SystemConsumer systemConsumer, SystemStreamPartition systemStreamPartition, String restoreOffset, SystemAdmin admin, boolean trimEnabled, String endOffset) {
        super(systemConsumer, systemStreamPartition, endOffset, admin);
        this.restoreOffset = restoreOffset;
        this.trimEnabled = trimEnabled;
        if (this.trimEnabled && restoreOffset == null) {
            this.mode = Mode.TRIM;
        }
    }

    @Override
    public IncomingMessageEnvelope next() {
        IncomingMessageEnvelope envelope = super.next();
        if (this.trimEnabled && (this.restoreOffset == null || this.admin.offsetComparator(envelope.getOffset(), this.restoreOffset) > 0)) {
            this.mode = Mode.TRIM;
        }
        return envelope;
    }

    public Mode getMode() {
        return this.mode;
    }

    public static enum Mode {
        RESTORE,
        TRIM;

    }
}

