/*
 * Decompiled with CFR 0.152.
 */
package org.apache.samza.system;

import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import org.apache.samza.startpoint.Startpoint;
import org.apache.samza.system.StreamSpec;
import org.apache.samza.system.StreamValidationException;
import org.apache.samza.system.SystemStream;
import org.apache.samza.system.SystemStreamMetadata;
import org.apache.samza.system.SystemStreamPartition;

public interface SystemAdmin {
    default public void start() {
    }

    default public void stop() {
    }

    default public boolean isStopped() {
        return false;
    }

    public Map<SystemStreamPartition, String> getOffsetsAfter(Map<SystemStreamPartition, String> var1);

    public Map<String, SystemStreamMetadata> getSystemStreamMetadata(Set<String> var1);

    default public Map<SystemStreamPartition, SystemStreamMetadata.SystemStreamPartitionMetadata> getSSPMetadata(Set<SystemStreamPartition> ssps) {
        Set<String> streams = ssps.stream().map(SystemStream::getStream).collect(Collectors.toSet());
        Map<String, SystemStreamMetadata> streamToSystemStreamMetadata = this.getSystemStreamMetadata(streams);
        HashMap<SystemStreamPartition, SystemStreamMetadata.SystemStreamPartitionMetadata> sspToSSPMetadata = new HashMap<SystemStreamPartition, SystemStreamMetadata.SystemStreamPartitionMetadata>();
        for (SystemStreamPartition ssp : ssps) {
            SystemStreamMetadata.SystemStreamPartitionMetadata sspMetadata;
            SystemStreamMetadata systemStreamMetadata = streamToSystemStreamMetadata.get(ssp.getStream());
            if (systemStreamMetadata == null || (sspMetadata = systemStreamMetadata.getSystemStreamPartitionMetadata().get(ssp.getPartition())) == null) continue;
            sspToSSPMetadata.put(ssp, sspMetadata);
        }
        return sspToSSPMetadata;
    }

    public Integer offsetComparator(String var1, String var2);

    default public boolean createStream(StreamSpec streamSpec) {
        throw new UnsupportedOperationException();
    }

    default public void validateStream(StreamSpec streamSpec) throws StreamValidationException {
        throw new UnsupportedOperationException();
    }

    default public boolean clearStream(StreamSpec streamSpec) {
        throw new UnsupportedOperationException();
    }

    default public void deleteMessages(Map<SystemStreamPartition, String> offsets) {
    }

    default public Map<String, SystemStreamMetadata> getSystemStreamPartitionCounts(Set<String> streamNames, long cacheTTL) {
        return this.getSystemStreamMetadata(streamNames);
    }

    default public Set<SystemStream> getAllSystemStreams() {
        throw new UnsupportedOperationException();
    }

    default public String resolveStartpointToOffset(SystemStreamPartition systemStreamPartition, Startpoint startpoint) {
        throw new UnsupportedOperationException();
    }
}

