/*
 * Decompiled with CFR 0.152.
 */
package org.apache.samza.system.descriptors;

import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import org.apache.samza.serializers.Serde;
import org.apache.samza.system.SystemStreamMetadata;
import org.apache.samza.system.descriptors.InputTransformer;
import org.apache.samza.system.descriptors.StreamDescriptor;
import org.apache.samza.system.descriptors.SystemDescriptor;

public abstract class InputDescriptor<StreamMessageType, SubClass extends InputDescriptor<StreamMessageType, SubClass>>
extends StreamDescriptor<StreamMessageType, SubClass> {
    private static final String RESET_OFFSET_CONFIG_KEY = "streams.%s.samza.reset.offset";
    private static final String OFFSET_DEFAULT_CONFIG_KEY = "streams.%s.samza.offset.default";
    private static final String PRIORITY_CONFIG_KEY = "streams.%s.samza.priority";
    private static final String BOOTSTRAP_CONFIG_KEY = "streams.%s.samza.bootstrap";
    private static final String BOUNDED_CONFIG_KEY = "streams.%s.samza.bounded";
    private static final String DELETE_COMMITTED_MESSAGES_CONFIG_KEY = "streams.%s.samza.delete.committed.messages";
    private final Optional<InputTransformer> transformerOptional;
    private Optional<Boolean> resetOffsetOptional = Optional.empty();
    private Optional<SystemStreamMetadata.OffsetType> offsetDefaultOptional = Optional.empty();
    private Optional<Integer> priorityOptional = Optional.empty();
    private Optional<Boolean> isBootstrapOptional = Optional.empty();
    private Optional<Boolean> isBoundedOptional = Optional.empty();
    private Optional<Boolean> deleteCommittedMessagesOptional = Optional.empty();

    public InputDescriptor(String streamId, Serde serde, SystemDescriptor systemDescriptor, InputTransformer transformer) {
        super(streamId, serde, systemDescriptor);
        this.transformerOptional = transformer != null ? Optional.of(transformer) : systemDescriptor.getTransformer();
    }

    public SubClass shouldResetOffset() {
        this.resetOffsetOptional = Optional.of(true);
        return (SubClass)this;
    }

    public SubClass withOffsetDefault(SystemStreamMetadata.OffsetType offsetDefault) {
        this.offsetDefaultOptional = Optional.ofNullable(offsetDefault);
        return (SubClass)this;
    }

    public SubClass withPriority(int priority) {
        this.priorityOptional = Optional.of(priority);
        return (SubClass)this;
    }

    public SubClass shouldBootstrap() {
        this.isBootstrapOptional = Optional.of(true);
        return (SubClass)this;
    }

    public SubClass isBounded() {
        this.isBoundedOptional = Optional.of(true);
        return (SubClass)this;
    }

    public SubClass shouldDeleteCommittedMessages() {
        this.deleteCommittedMessagesOptional = Optional.of(true);
        return (SubClass)this;
    }

    public Optional<InputTransformer> getTransformer() {
        return this.transformerOptional;
    }

    @Override
    public Map<String, String> toConfig() {
        HashMap<String, String> configs = new HashMap<String, String>(super.toConfig());
        String streamId = this.getStreamId();
        this.offsetDefaultOptional.ifPresent(od -> configs.put(String.format(OFFSET_DEFAULT_CONFIG_KEY, streamId), od.name().toLowerCase()));
        this.resetOffsetOptional.ifPresent(resetOffset -> configs.put(String.format(RESET_OFFSET_CONFIG_KEY, streamId), Boolean.toString(resetOffset)));
        this.priorityOptional.ifPresent(priority -> configs.put(String.format(PRIORITY_CONFIG_KEY, streamId), Integer.toString(priority)));
        this.isBootstrapOptional.ifPresent(bootstrap -> configs.put(String.format(BOOTSTRAP_CONFIG_KEY, streamId), Boolean.toString(bootstrap)));
        this.isBoundedOptional.ifPresent(bounded -> configs.put(String.format(BOUNDED_CONFIG_KEY, streamId), Boolean.toString(bounded)));
        this.deleteCommittedMessagesOptional.ifPresent(deleteCommittedMessages -> configs.put(String.format(DELETE_COMMITTED_MESSAGES_CONFIG_KEY, streamId), Boolean.toString(deleteCommittedMessages)));
        return Collections.unmodifiableMap(configs);
    }
}

