/*
 * Decompiled with CFR 0.152.
 */
package org.apache.samza.system.descriptors;

import com.google.common.base.Preconditions;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import java.util.regex.Pattern;
import org.apache.commons.lang3.StringUtils;
import org.apache.samza.serializers.Serde;
import org.apache.samza.system.descriptors.SystemDescriptor;

public abstract class StreamDescriptor<StreamMessageType, SubClass extends StreamDescriptor<StreamMessageType, SubClass>> {
    private static final String SYSTEM_CONFIG_KEY = "streams.%s.samza.system";
    private static final String PHYSICAL_NAME_CONFIG_KEY = "streams.%s.samza.physical.name";
    private static final String STREAM_CONFIGS_CONFIG_KEY = "streams.%s.%s";
    private static final Pattern STREAM_ID_PATTERN = Pattern.compile("[\\d\\w-_]+");
    private final String streamId;
    private final Serde serde;
    private final SystemDescriptor systemDescriptor;
    private final Map<String, String> streamConfigs = new HashMap<String, String>();
    private Optional<String> physicalNameOptional = Optional.empty();

    StreamDescriptor(String streamId, Serde serde, SystemDescriptor systemDescriptor) {
        Preconditions.checkArgument((systemDescriptor != null ? 1 : 0) != 0, (Object)String.format("SystemDescriptor must not be null. streamId: %s", streamId));
        String systemName = systemDescriptor.getSystemName();
        Preconditions.checkState((boolean)this.isValidStreamId(streamId), (Object)String.format("streamId must be non-empty and must not contain spaces or special characters. streamId: %s, systemName: %s", streamId, systemName));
        Preconditions.checkArgument((serde != null ? 1 : 0) != 0, (Object)String.format("Serde must not be null. streamId: %s systemName: %s", streamId, systemName));
        this.streamId = streamId;
        this.serde = serde;
        this.systemDescriptor = systemDescriptor;
    }

    public SubClass withPhysicalName(String physicalName) {
        this.physicalNameOptional = Optional.ofNullable(physicalName);
        return (SubClass)this;
    }

    public SubClass withStreamConfigs(Map<String, String> streamConfigs) {
        this.streamConfigs.putAll(streamConfigs);
        return (SubClass)this;
    }

    public String getStreamId() {
        return this.streamId;
    }

    public String getSystemName() {
        return this.systemDescriptor.getSystemName();
    }

    public Serde getSerde() {
        return this.serde;
    }

    public SystemDescriptor getSystemDescriptor() {
        return this.systemDescriptor;
    }

    public Optional<String> getPhysicalName() {
        return this.physicalNameOptional;
    }

    private boolean isValidStreamId(String id) {
        return StringUtils.isNotBlank((CharSequence)id) && STREAM_ID_PATTERN.matcher(id).matches();
    }

    public Map<String, String> toConfig() {
        HashMap<String, String> configs = new HashMap<String, String>();
        configs.put(String.format(SYSTEM_CONFIG_KEY, this.streamId), this.getSystemName());
        this.physicalNameOptional.ifPresent(physicalName -> configs.put(String.format(PHYSICAL_NAME_CONFIG_KEY, this.streamId), (String)physicalName));
        this.streamConfigs.forEach((key, value) -> configs.put(String.format(STREAM_CONFIGS_CONFIG_KEY, this.streamId, key), (String)value));
        return Collections.unmodifiableMap(configs);
    }
}

