/*
 * Decompiled with CFR 0.152.
 */
package org.apache.samza.table.batching;

import java.io.Serializable;
import java.time.Duration;
import org.apache.samza.table.batching.Batch;
import org.apache.samza.table.remote.TablePart;

public abstract class BatchProvider<K, V>
implements TablePart,
Serializable {
    private int maxBatchSize = 100;
    private Duration maxBatchDelay = Duration.ofMillis(100L);

    public abstract Batch<K, V> getBatch();

    public BatchProvider<K, V> withMaxBatchSize(int maxBatchSize) {
        this.maxBatchSize = maxBatchSize;
        return this;
    }

    public BatchProvider<K, V> withMaxBatchDelay(Duration maxBatchDelay) {
        this.maxBatchDelay = maxBatchDelay;
        return this;
    }

    public int getMaxBatchSize() {
        return this.maxBatchSize;
    }

    public Duration getMaxBatchDelay() {
        return this.maxBatchDelay;
    }
}

