/*
 * Decompiled with CFR 0.152.
 */
package org.apache.samza.table.descriptors;

import com.google.common.base.Preconditions;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import org.apache.samza.config.Config;
import org.apache.samza.config.JavaTableConfig;
import org.apache.samza.table.descriptors.TableDescriptor;

public abstract class BaseTableDescriptor<K, V, D extends BaseTableDescriptor<K, V, D>>
implements TableDescriptor<K, V, D> {
    protected final String tableId;
    protected final Map<String, String> config = new HashMap<String, String>();

    protected BaseTableDescriptor(String tableId) {
        this.tableId = tableId;
    }

    public D withConfig(String key, String value) {
        this.config.put(key, value);
        return (D)this;
    }

    @Override
    public String getTableId() {
        return this.tableId;
    }

    @Override
    public Map<String, String> toConfig(Config jobConfig) {
        Preconditions.checkNotNull((Object)jobConfig, (Object)"Job config is null");
        this.validate();
        HashMap<String, String> tableConfig = new HashMap<String, String>(this.config);
        tableConfig.put(String.format(JavaTableConfig.TABLE_PROVIDER_FACTORY, this.tableId), this.getProviderFactoryClassName());
        return Collections.unmodifiableMap(tableConfig);
    }

    public abstract String getProviderFactoryClassName();

    protected abstract void validate();

    protected void addTableConfig(String key, String value, Map<String, String> tableConfig) {
        tableConfig.put(JavaTableConfig.buildKey(this.tableId, key), value);
    }
}

