/*
 * Decompiled with CFR 0.152.
 */
package org.apache.samza.table.descriptors;

import com.google.common.base.Preconditions;
import com.google.common.cache.Cache;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import org.apache.samza.config.Config;
import org.apache.samza.table.descriptors.BaseTableDescriptor;
import org.apache.samza.table.utils.SerdeUtils;

public class GuavaCacheTableDescriptor<K, V>
extends BaseTableDescriptor<K, V, GuavaCacheTableDescriptor<K, V>> {
    public static final String PROVIDER_FACTORY_CLASS_NAME = "org.apache.samza.table.caching.guava.GuavaCacheTableProviderFactory";
    public static final String GUAVA_CACHE = "guavaCache";
    private Cache<K, V> cache;

    public GuavaCacheTableDescriptor(String tableId) {
        super(tableId);
    }

    public GuavaCacheTableDescriptor withCache(Cache<K, V> cache) {
        this.cache = cache;
        return this;
    }

    @Override
    public String getProviderFactoryClassName() {
        return PROVIDER_FACTORY_CLASS_NAME;
    }

    @Override
    public Map<String, String> toConfig(Config jobConfig) {
        HashMap<String, String> tableConfig = new HashMap<String, String>(super.toConfig(jobConfig));
        this.addTableConfig(GUAVA_CACHE, SerdeUtils.serialize("Guava cache", this.cache), tableConfig);
        return Collections.unmodifiableMap(tableConfig);
    }

    @Override
    protected void validate() {
        Preconditions.checkArgument((this.cache != null ? 1 : 0) != 0, (Object)"Must provide a Guava cache instance.");
    }
}

