/*
 * Decompiled with CFR 0.152.
 */
package org.apache.samza.table.descriptors;

import com.google.common.base.Preconditions;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.regex.Pattern;
import org.apache.commons.lang3.StringUtils;
import org.apache.samza.config.Config;
import org.apache.samza.serializers.KVSerde;
import org.apache.samza.storage.SideInputsProcessor;
import org.apache.samza.table.descriptors.BaseTableDescriptor;
import org.apache.samza.table.utils.SerdeUtils;

public abstract class LocalTableDescriptor<K, V, D extends LocalTableDescriptor<K, V, D>>
extends BaseTableDescriptor<K, V, D> {
    public static final Pattern SYSTEM_STREAM_NAME_PATTERN = Pattern.compile("[\\d\\w-_.]+");
    protected final KVSerde<K, V> serde;
    protected boolean enableChangelog;
    protected String changelogStream;
    protected Integer changelogReplicationFactor;
    protected List<String> sideInputs;
    protected SideInputsProcessor sideInputsProcessor;

    public LocalTableDescriptor(String tableId, KVSerde<K, V> serde) {
        super(tableId);
        this.serde = serde;
    }

    public D withSideInputs(List<String> sideInputs) {
        this.sideInputs = sideInputs;
        this.enableChangelog = false;
        this.changelogStream = null;
        this.changelogReplicationFactor = null;
        return (D)this;
    }

    public D withSideInputsProcessor(SideInputsProcessor sideInputsProcessor) {
        this.sideInputsProcessor = sideInputsProcessor;
        return (D)this;
    }

    public D withChangelogEnabled() {
        this.enableChangelog = true;
        return (D)this;
    }

    public D withChangelogStream(String changelogStream) {
        this.enableChangelog = true;
        this.changelogStream = changelogStream;
        return (D)this;
    }

    public D withChangelogReplicationFactor(int replicationFactor) {
        this.enableChangelog = true;
        this.changelogReplicationFactor = replicationFactor;
        return (D)this;
    }

    @Override
    public Map<String, String> toConfig(Config jobConfig) {
        HashMap<String, String> tableConfig = new HashMap<String, String>(super.toConfig(jobConfig));
        if (this.sideInputs != null && !this.sideInputs.isEmpty()) {
            this.sideInputs.forEach(si -> Preconditions.checkState((boolean)this.isValidSystemStreamName((String)si), (Object)String.format("Side input stream %s doesn't confirm to pattern %s", si, SYSTEM_STREAM_NAME_PATTERN)));
            String formattedSideInputs = String.join((CharSequence)",", this.sideInputs);
            this.addStoreConfig("side.inputs", formattedSideInputs, tableConfig);
            this.addStoreConfig("side.inputs.processor.serialized.instance", SerdeUtils.serialize("Side Inputs Processor", this.sideInputsProcessor), tableConfig);
        }
        if (this.enableChangelog) {
            if (StringUtils.isEmpty((CharSequence)this.changelogStream)) {
                String jobName = (String)jobConfig.get("job.name");
                Preconditions.checkNotNull((Object)jobName, (Object)"job.name not found in job config");
                String jobId = (String)jobConfig.get("job.id");
                Preconditions.checkNotNull((Object)jobId, (Object)"job.id not found in job config");
                this.changelogStream = String.format("%s-%s-table-%s", jobName, jobId, this.tableId);
            }
            Preconditions.checkState((boolean)this.isValidSystemStreamName(this.changelogStream), (Object)String.format("Changelog stream %s doesn't confirm to pattern %s", this.changelogStream, SYSTEM_STREAM_NAME_PATTERN));
            this.addStoreConfig("changelog", this.changelogStream, tableConfig);
            if (this.changelogReplicationFactor != null) {
                this.addStoreConfig("changelog.replication.factor", this.changelogReplicationFactor.toString(), tableConfig);
            }
        }
        return Collections.unmodifiableMap(tableConfig);
    }

    public List<String> getSideInputs() {
        return this.sideInputs;
    }

    public KVSerde<K, V> getSerde() {
        return this.serde;
    }

    @Override
    protected void validate() {
        if (this.sideInputs != null || this.sideInputsProcessor != null) {
            Preconditions.checkArgument((this.sideInputs != null && !this.sideInputs.isEmpty() && this.sideInputsProcessor != null ? 1 : 0) != 0, (Object)String.format("Invalid side input configuration for table: %s. Both side inputs and the processor must be provided", this.tableId));
        }
        if (!this.enableChangelog) {
            Preconditions.checkState((this.changelogStream == null ? 1 : 0) != 0, (Object)String.format("Invalid changelog configuration for table: %s. Changelog must be enabled, when changelog stream name is provided", this.tableId));
            Preconditions.checkState((this.changelogReplicationFactor == null ? 1 : 0) != 0, (Object)String.format("Invalid changelog configuration for table: %s. Changelog must be enabled, when changelog replication factor is provided", this.tableId));
        }
    }

    protected void addStoreConfig(String key, String value, Map<String, String> tableConfig) {
        tableConfig.put(String.format("stores.%s.%s", this.tableId, key), value);
    }

    private boolean isValidSystemStreamName(String name) {
        return StringUtils.isNotBlank((CharSequence)name) && SYSTEM_STREAM_NAME_PATTERN.matcher(name).matches();
    }
}

