/*
 * Decompiled with CFR 0.152.
 */
package org.apache.samza.table.remote;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Preconditions;
import java.io.Serializable;
import java.util.Collection;
import java.util.Collections;
import org.apache.samza.annotation.InterfaceStability;
import org.apache.samza.metrics.Timer;
import org.apache.samza.storage.kv.Entry;
import org.apache.samza.table.remote.TablePart;
import org.apache.samza.util.RateLimiter;

public class TableRateLimiter<K, V> {
    private final String tag;
    private final CreditFunction<K, V> creditFn;
    @VisibleForTesting
    final RateLimiter rateLimiter;
    private Timer waitTimeMetric;

    public TableRateLimiter(String tableId, RateLimiter rateLimiter, CreditFunction<K, V> creditFn, String tag) {
        Preconditions.checkNotNull((Object)rateLimiter);
        Preconditions.checkArgument((boolean)rateLimiter.getSupportedTags().contains(tag), (Object)String.format("Rate limiter for table %s doesn't support %s", tableId, tag));
        this.rateLimiter = rateLimiter;
        this.creditFn = creditFn;
        this.tag = tag;
    }

    public void setTimerMetric(Timer timer) {
        Preconditions.checkNotNull((Object)timer);
        this.waitTimeMetric = timer;
    }

    int getCredits(K key, V value, Object ... args) {
        return this.creditFn == null ? 1 : this.creditFn.getCredits(key, value, args);
    }

    int getCredits(Collection<K> keys, Object ... args) {
        if (this.creditFn == null) {
            return keys.size();
        }
        return keys.stream().mapToInt(k -> this.creditFn.getCredits(k, null, args)).sum();
    }

    int getEntryCredits(Collection<Entry<K, V>> entries, Object ... args) {
        if (this.creditFn == null) {
            return entries.size();
        }
        return entries.stream().mapToInt(e -> this.creditFn.getCredits(e.getKey(), e.getValue(), args)).sum();
    }

    int getCredits(int opId, Object ... args) {
        return this.creditFn == null ? 1 : this.creditFn.getCredits(opId, args);
    }

    private void throttle(int credits) {
        long startNs = System.nanoTime();
        this.rateLimiter.acquire(Collections.singletonMap(this.tag, credits));
        if (this.waitTimeMetric != null) {
            this.waitTimeMetric.update(System.nanoTime() - startNs);
        }
    }

    public void throttle(K key, Object ... args) {
        this.throttle(this.getCredits(key, null, args));
    }

    public void throttle(K key, V value, Object ... args) {
        this.throttle(this.getCredits(key, value, args));
    }

    public void throttle(int opId, Object ... args) {
        this.throttle(this.getCredits(opId, args));
    }

    public void throttle(Collection<K> keys, Object ... args) {
        this.throttle(this.getCredits(keys, args));
    }

    public void throttleRecords(Collection<Entry<K, V>> records, Object ... args) {
        this.throttle(this.getEntryCredits(records, args));
    }

    @InterfaceStability.Unstable
    public static interface CreditFunction<K, V>
    extends TablePart,
    Serializable {
        public int getCredits(K var1, V var2, Object ... var3);

        default public int getCredits(int opId, Object ... args) {
            return 1;
        }
    }
}

