/*
 * Decompiled with CFR 0.152.
 */
package org.apache.samza.table.remote;

import com.google.common.collect.Iterables;
import java.util.Collection;
import java.util.Map;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ExecutionException;
import java.util.stream.Collectors;
import org.apache.samza.SamzaException;
import org.apache.samza.annotation.InterfaceStability;
import org.apache.samza.table.remote.TableFunction;

@InterfaceStability.Unstable
public interface TableReadFunction<K, V>
extends TableFunction {
    default public V get(K key) {
        try {
            return this.getAsync(key).get();
        }
        catch (InterruptedException | ExecutionException e) {
            throw new SamzaException("GET failed for " + key, e);
        }
    }

    public CompletableFuture<V> getAsync(K var1);

    default public CompletableFuture<V> getAsync(K key, Object ... args) {
        throw new SamzaException("Not supported");
    }

    default public Map<K, V> getAll(Collection<K> keys) {
        try {
            return this.getAllAsync(keys).get();
        }
        catch (InterruptedException | ExecutionException e) {
            throw new SamzaException("GET_ALL failed for " + keys, e);
        }
    }

    default public CompletableFuture<Map<K, V>> getAllAsync(Collection<K> keys) {
        Map<Object, CompletableFuture> getFutures = keys.stream().collect(Collectors.toMap(k -> k, k -> this.getAsync(k)));
        return CompletableFuture.allOf((CompletableFuture[])Iterables.toArray(getFutures.values(), CompletableFuture.class)).thenApply(future -> getFutures.entrySet().stream().collect(Collectors.toMap(e -> e.getKey(), e -> ((CompletableFuture)e.getValue()).join())));
    }

    default public CompletableFuture<Map<K, V>> getAllAsync(Collection<K> keys, Object ... args) {
        throw new SamzaException("Not supported");
    }

    default public <T> CompletableFuture<T> readAsync(int opId, Object ... args) {
        throw new SamzaException("Not supported");
    }
}

