/*
 * Decompiled with CFR 0.152.
 */
package org.apache.samza.table.remote;

import com.google.common.collect.Iterables;
import java.util.Collection;
import java.util.List;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ExecutionException;
import java.util.stream.Collectors;
import org.apache.samza.SamzaException;
import org.apache.samza.annotation.InterfaceStability;
import org.apache.samza.storage.kv.Entry;
import org.apache.samza.table.remote.TableFunction;

@InterfaceStability.Unstable
public interface TableWriteFunction<K, V>
extends TableFunction {
    default public void put(K key, V record) {
        try {
            this.putAsync(key, record).get();
        }
        catch (InterruptedException | ExecutionException e) {
            throw new SamzaException("PUT failed for " + key, e);
        }
    }

    public CompletableFuture<Void> putAsync(K var1, V var2);

    default public CompletableFuture<Void> putAsync(K key, V record, Object ... args) {
        throw new SamzaException("Not supported");
    }

    default public void putAll(List<Entry<K, V>> records) {
        try {
            this.putAllAsync(records).get();
        }
        catch (InterruptedException | ExecutionException e) {
            throw new SamzaException("PUT_ALL failed for " + records, e);
        }
    }

    default public CompletableFuture<Void> putAllAsync(Collection<Entry<K, V>> records) {
        List putFutures = records.stream().map(e -> this.putAsync(e.getKey(), e.getValue())).collect(Collectors.toList());
        return CompletableFuture.allOf((CompletableFuture[])Iterables.toArray(putFutures, CompletableFuture.class));
    }

    default public CompletableFuture<Void> putAllAsync(Collection<Entry<K, V>> records, Object ... args) {
        throw new SamzaException("Not supported");
    }

    default public void delete(K key) {
        try {
            this.deleteAsync(key).get();
        }
        catch (InterruptedException | ExecutionException e) {
            throw new SamzaException("DELETE failed for " + key, e);
        }
    }

    public CompletableFuture<Void> deleteAsync(K var1);

    default public CompletableFuture<Void> deleteAsync(K key, Object ... args) {
        throw new SamzaException("Not supported");
    }

    default public void deleteAll(Collection<K> keys) {
        try {
            this.deleteAllAsync(keys).get();
        }
        catch (InterruptedException | ExecutionException e) {
            throw new SamzaException("DELETE failed for " + keys, e);
        }
    }

    default public CompletableFuture<Void> deleteAllAsync(Collection<K> keys) {
        List deleteFutures = keys.stream().map(this::deleteAsync).collect(Collectors.toList());
        return CompletableFuture.allOf((CompletableFuture[])Iterables.toArray(deleteFutures, CompletableFuture.class));
    }

    default public CompletableFuture<Void> deleteAllAsync(Collection<K> keys, Object ... args) {
        throw new SamzaException("Not supported");
    }

    default public <T> CompletableFuture<T> writeAsync(int opId, Object ... args) {
        throw new SamzaException("Not supported");
    }

    default public void flush() {
    }
}

