/*
 * Decompiled with CFR 0.152.
 */
package org.apache.samza.system.hdfs;

import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.commons.lang.StringUtils;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FSDataOutputStream;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.samza.Partition;
import org.apache.samza.SamzaException;
import org.apache.samza.config.Config;
import org.apache.samza.system.IncomingMessageEnvelope;
import org.apache.samza.system.SystemAdmin;
import org.apache.samza.system.SystemStreamMetadata;
import org.apache.samza.system.SystemStreamPartition;
import org.apache.samza.system.hdfs.HdfsConfig;
import org.apache.samza.system.hdfs.PartitionDescriptorUtil;
import org.apache.samza.system.hdfs.partitioner.DirectoryPartitioner;
import org.apache.samza.system.hdfs.partitioner.HdfsFileSystemAdapter;
import org.apache.samza.system.hdfs.reader.HdfsReaderFactory;
import org.apache.samza.system.hdfs.reader.MultiFileHdfsReader;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class HdfsSystemAdmin
implements SystemAdmin {
    private static final Logger LOG = LoggerFactory.getLogger(HdfsSystemAdmin.class);
    private final HdfsConfig hdfsConfig;
    private final DirectoryPartitioner directoryPartitioner;
    private final String stagingDirectory;
    private final HdfsReaderFactory.ReaderType readerType;

    public HdfsSystemAdmin(String systemName, Config config) {
        this.hdfsConfig = new HdfsConfig(config);
        this.directoryPartitioner = new DirectoryPartitioner(this.hdfsConfig.getPartitionerWhiteList(systemName), this.hdfsConfig.getPartitionerBlackList(systemName), this.hdfsConfig.getPartitionerGroupPattern(systemName), new HdfsFileSystemAdapter());
        this.stagingDirectory = this.hdfsConfig.getStagingDirectory(systemName);
        this.readerType = HdfsReaderFactory.getType(this.hdfsConfig.getFileReaderType(systemName));
    }

    public Map<SystemStreamPartition, String> getOffsetsAfter(Map<SystemStreamPartition, String> offsets) {
        return offsets;
    }

    /*
     * Exception decompiling
     */
    static Map<Partition, List<String>> obtainPartitionDescriptorMap(String stagingDirectory, String streamName) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 4 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    private void persistPartitionDescriptor(String streamName, Map<Partition, List<String>> partitionDescriptorMap) {
        block28: {
            if (StringUtils.isBlank((String)this.stagingDirectory) || StringUtils.isBlank((String)streamName)) {
                LOG.warn("Staging directory ({}) or stream name ({}) is empty", (Object)this.stagingDirectory, (Object)streamName);
                return;
            }
            Path targetPath = PartitionDescriptorUtil.getPartitionDescriptorPath(this.stagingDirectory, streamName);
            try (FileSystem fs = targetPath.getFileSystem(new Configuration());){
                if (fs.exists(targetPath)) {
                    LOG.warn(targetPath.toString() + " exists. Skip persisting partition descriptor.");
                    break block28;
                }
                LOG.info("About to persist partition descriptors to path: " + targetPath.toString());
                try (FSDataOutputStream fos = fs.create(targetPath);){
                    fos.write(PartitionDescriptorUtil.getJsonFromDescriptorMap(partitionDescriptorMap).getBytes(StandardCharsets.UTF_8));
                }
            }
            catch (IOException e) {
                throw new SamzaException("Failed to validate/persist partition description on hdfs.", (Throwable)e);
            }
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private boolean partitionDescriptorExists(String streamName) {
        if (StringUtils.isBlank((String)this.stagingDirectory) || StringUtils.isBlank((String)streamName)) {
            LOG.warn("Staging directory ({}) or stream name ({}) is empty", (Object)this.stagingDirectory, (Object)streamName);
            return false;
        }
        Path targetPath = PartitionDescriptorUtil.getPartitionDescriptorPath(this.stagingDirectory, streamName);
        try (FileSystem fs = targetPath.getFileSystem(new Configuration());){
            boolean bl = fs.exists(targetPath);
            return bl;
        }
        catch (IOException e) {
            throw new SamzaException("Failed to obtain information about path: " + targetPath);
        }
    }

    public Map<String, SystemStreamMetadata> getSystemStreamMetadata(Set<String> streamNames) {
        HashMap<String, SystemStreamMetadata> systemStreamMetadataMap = new HashMap<String, SystemStreamMetadata>();
        streamNames.forEach(streamName -> {
            systemStreamMetadataMap.put((String)streamName, new SystemStreamMetadata(streamName, this.directoryPartitioner.getPartitionMetadataMap((String)streamName, HdfsSystemAdmin.obtainPartitionDescriptorMap(this.stagingDirectory, streamName))));
            if (!this.partitionDescriptorExists((String)streamName)) {
                this.persistPartitionDescriptor((String)streamName, this.directoryPartitioner.getPartitionDescriptor((String)streamName));
            }
        });
        return systemStreamMetadataMap;
    }

    public Integer offsetComparator(String offset1, String offset2) {
        int fileIndex2;
        if (StringUtils.isBlank((String)offset1) || StringUtils.isBlank((String)offset2)) {
            return null;
        }
        if (offset1.equals(IncomingMessageEnvelope.END_OF_STREAM_OFFSET)) {
            return offset2.equals(IncomingMessageEnvelope.END_OF_STREAM_OFFSET) ? 0 : 1;
        }
        if (offset2.equals(IncomingMessageEnvelope.END_OF_STREAM_OFFSET)) {
            return -1;
        }
        int fileIndex1 = MultiFileHdfsReader.getCurFileIndex(offset1);
        if (fileIndex1 == (fileIndex2 = MultiFileHdfsReader.getCurFileIndex(offset2))) {
            String offsetWithinFile1 = MultiFileHdfsReader.getCurSingleFileOffset(offset1);
            String offsetWithinFile2 = MultiFileHdfsReader.getCurSingleFileOffset(offset2);
            return HdfsReaderFactory.offsetComparator(this.readerType, offsetWithinFile1, offsetWithinFile2);
        }
        return Integer.compare(fileIndex1, fileIndex2);
    }
}

