/*
 * Decompiled with CFR 0.152.
 */
package org.apache.samza.system.hdfs;

import org.apache.samza.config.Config;
import org.apache.samza.config.ConfigException;
import org.apache.samza.config.JobConfig;
import org.apache.samza.metrics.MetricsRegistry;
import org.apache.samza.system.SystemFactory;
import org.apache.samza.system.hdfs.HdfsConfig$;
import org.apache.samza.system.hdfs.HdfsSystemAdmin;
import org.apache.samza.system.hdfs.HdfsSystemConsumer;
import org.apache.samza.system.hdfs.HdfsSystemProducer;
import org.apache.samza.system.hdfs.HdfsSystemProducer$;
import org.apache.samza.system.hdfs.HdfsSystemProducerMetrics;
import org.apache.samza.util.Logging;
import org.apache.samza.util.ScalaJavaUtil;
import org.slf4j.Logger;
import scala.Function0;
import scala.Predef$;
import scala.Serializable;
import scala.collection.Seq;
import scala.collection.immutable.StringOps;
import scala.reflect.ScalaSignature;
import scala.runtime.Nothing$;

@ScalaSignature(bytes="\u0006\u0001\u00014A!\u0001\u0002\u0001\u001b\t\t\u0002\n\u001a4t'f\u001cH/Z7GC\u000e$xN]=\u000b\u0005\r!\u0011\u0001\u00025eMNT!!\u0002\u0004\u0002\rML8\u000f^3n\u0015\t9\u0001\"A\u0003tC6T\u0018M\u0003\u0002\n\u0015\u00051\u0011\r]1dQ\u0016T\u0011aC\u0001\u0004_J<7\u0001A\n\u0005\u000191\"\u0004\u0005\u0002\u0010)5\t\u0001C\u0003\u0002\u0012%\u0005!A.\u00198h\u0015\u0005\u0019\u0012\u0001\u00026bm\u0006L!!\u0006\t\u0003\r=\u0013'.Z2u!\t9\u0002$D\u0001\u0005\u0013\tIBAA\u0007TsN$X-\u001c$bGR|'/\u001f\t\u00037yi\u0011\u0001\b\u0006\u0003;\u0019\tA!\u001e;jY&\u0011q\u0004\b\u0002\b\u0019><w-\u001b8h\u0011\u0015\t\u0003\u0001\"\u0001#\u0003\u0019a\u0014N\\5u}Q\t1\u0005\u0005\u0002%\u00015\t!\u0001C\u0003'\u0001\u0011\u0005q%A\u0006hKR\u001cuN\\:v[\u0016\u0014H\u0003\u0002\u0015,oy\u0002\"\u0001J\u0015\n\u0005)\u0012!A\u0005%eMN\u001c\u0016p\u001d;f[\u000e{gn];nKJDQ\u0001L\u0013A\u00025\n!b]=ti\u0016lg*Y7f!\tqCG\u0004\u00020e5\t\u0001GC\u00012\u0003\u0015\u00198-\u00197b\u0013\t\u0019\u0004'\u0001\u0004Qe\u0016$WMZ\u0005\u0003kY\u0012aa\u0015;sS:<'BA\u001a1\u0011\u0015AT\u00051\u0001:\u0003\u0019\u0019wN\u001c4jOB\u0011!\bP\u0007\u0002w)\u0011\u0001HB\u0005\u0003{m\u0012aaQ8oM&<\u0007\"B &\u0001\u0004\u0001\u0015\u0001\u0003:fO&\u001cHO]=\u0011\u0005\u0005#U\"\u0001\"\u000b\u0005\r3\u0011aB7fiJL7m]\u0005\u0003\u000b\n\u0013q\"T3ue&\u001c7OU3hSN$(/\u001f\u0005\u0006\u000f\u0002!\t\u0001S\u0001\fO\u0016$\bK]8ek\u000e,'\u000f\u0006\u0003J\u00196s\u0005C\u0001\u0013K\u0013\tY%A\u0001\nII\u001a\u001c8+_:uK6\u0004&o\u001c3vG\u0016\u0014\b\"\u0002\u0017G\u0001\u0004i\u0003\"\u0002\u001dG\u0001\u0004I\u0004\"B G\u0001\u0004\u0001\u0005\"\u0002)\u0001\t\u0003\t\u0016\u0001C4fi\u0006#W.\u001b8\u0015\u0007I+f\u000b\u0005\u0002%'&\u0011AK\u0001\u0002\u0010\u0011\u001247oU=ti\u0016l\u0017\tZ7j]\")Af\u0014a\u0001[!)\u0001h\u0014a\u0001s!)\u0001\f\u0001C\u00013\u0006Yq-\u001a;DY&,g\u000e^%e)\u0011i#\f\u00180\t\u000bm;\u0006\u0019A\u0017\u0002\u0005%$\u0007\"B/X\u0001\u0004i\u0013a\u00026pE:\u000bW.\u001a\u0005\u0006?^\u0003\r!L\u0001\u0006U>\u0014\u0017\n\u001a")
public class HdfsSystemFactory
implements SystemFactory,
Logging {
    private final String loggerName;
    private final Logger logger;
    private final String startupLoggerName;
    private final Logger startupLogger;
    private volatile byte bitmap$0;

    public String loggerName() {
        return this.loggerName;
    }

    private Logger logger$lzycompute() {
        HdfsSystemFactory hdfsSystemFactory = this;
        synchronized (hdfsSystemFactory) {
            if ((byte)(this.bitmap$0 & 1) == 0) {
                this.logger = Logging.class.logger((Logging)this);
                this.bitmap$0 = (byte)(this.bitmap$0 | 1);
            }
            return this.logger;
        }
    }

    public Logger logger() {
        return (byte)(this.bitmap$0 & 1) == 0 ? this.logger$lzycompute() : this.logger;
    }

    public String startupLoggerName() {
        return this.startupLoggerName;
    }

    private Logger startupLogger$lzycompute() {
        HdfsSystemFactory hdfsSystemFactory = this;
        synchronized (hdfsSystemFactory) {
            if ((byte)(this.bitmap$0 & 2) == 0) {
                this.startupLogger = Logging.class.startupLogger((Logging)this);
                this.bitmap$0 = (byte)(this.bitmap$0 | 2);
            }
            return this.startupLogger;
        }
    }

    public Logger startupLogger() {
        return (byte)(this.bitmap$0 & 2) == 0 ? this.startupLogger$lzycompute() : this.startupLogger;
    }

    public void org$apache$samza$util$Logging$_setter_$loggerName_$eq(String x$1) {
        this.loggerName = x$1;
    }

    public void org$apache$samza$util$Logging$_setter_$startupLoggerName_$eq(String x$1) {
        this.startupLoggerName = x$1;
    }

    public void startupLog(Function0<Object> message) {
        Logging.class.startupLog((Logging)this, message);
    }

    public void trace(Function0<Object> message) {
        Logging.class.trace((Logging)this, message);
    }

    public void trace(Function0<Object> message, Function0<Throwable> e) {
        Logging.class.trace((Logging)this, message, e);
    }

    public void debug(Function0<Object> message) {
        Logging.class.debug((Logging)this, message);
    }

    public void debug(Function0<Object> message, Function0<Throwable> e) {
        Logging.class.debug((Logging)this, message, e);
    }

    public void info(Function0<Object> message) {
        Logging.class.info((Logging)this, message);
    }

    public void info(Function0<Object> message, Function0<Throwable> e) {
        Logging.class.info((Logging)this, message, e);
    }

    public void warn(Function0<Object> message) {
        Logging.class.warn((Logging)this, message);
    }

    public void warn(Function0<Object> message, Function0<Throwable> e) {
        Logging.class.warn((Logging)this, message, e);
    }

    public void error(Function0<Object> message) {
        Logging.class.error((Logging)this, message);
    }

    public void error(Function0<Object> message, Function0<Throwable> e) {
        Logging.class.error((Logging)this, message, e);
    }

    public void putMDC(Function0<String> key, Function0<String> value) {
        Logging.class.putMDC((Logging)this, key, value);
    }

    public String getMDC(Function0<String> key) {
        return Logging.class.getMDC((Logging)this, key);
    }

    public void removeMDC(Function0<String> key) {
        Logging.class.removeMDC((Logging)this, key);
    }

    public void clearMDC() {
        Logging.class.clearMDC((Logging)this);
    }

    public HdfsSystemConsumer getConsumer(String systemName, Config config, MetricsRegistry registry) {
        return new HdfsSystemConsumer(systemName, config, new HdfsSystemConsumer.HdfsSystemConsumerMetrics(registry));
    }

    public HdfsSystemProducer getProducer(String systemName, Config config, MetricsRegistry registry) {
        JobConfig jobConfig = new JobConfig(config);
        String jobName = (String)ScalaJavaUtil.JavaOptionals$.MODULE$.toRichOptional(jobConfig.getName()).toOption().getOrElse((Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final Nothing$ apply() {
                throw new ConfigException("Missing job name.");
            }
        });
        String jobId = jobConfig.getJobId();
        String clientId = this.getClientId("samza-producer", jobName, jobId);
        HdfsSystemProducerMetrics metrics = new HdfsSystemProducerMetrics(systemName, registry);
        return new HdfsSystemProducer(systemName, clientId, HdfsConfig$.MODULE$.Config2Hdfs(config), metrics, HdfsSystemProducer$.MODULE$.$lessinit$greater$default$5());
    }

    public HdfsSystemAdmin getAdmin(String systemName, Config config) {
        return new HdfsSystemAdmin(systemName, config);
    }

    public String getClientId(String id, String jobName, String jobId) {
        return new StringOps(Predef$.MODULE$.augmentString("%s-%s-%s")).format((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{id.replaceAll("[^A-Za-z0-9]", "_"), jobName.replaceAll("[^A-Za-z0-9]", "_"), jobId.replaceAll("[^A-Za-z0-9]", "_")}));
    }

    public HdfsSystemFactory() {
        Logging.class.$init$((Logging)this);
    }
}

