/*
 * Decompiled with CFR 0.152.
 */
package org.apache.samza.system.hdfs;

import java.io.IOException;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.hadoop.fs.Path;
import org.apache.samza.Partition;
import org.apache.samza.SamzaException;
import org.codehaus.jackson.map.ObjectMapper;
import org.codehaus.jettison.json.JSONException;
import org.codehaus.jettison.json.JSONObject;

public class PartitionDescriptorUtil {
    private static final int INDENT_FACTOR = 2;
    private static final String DELIMITER = ",";

    private PartitionDescriptorUtil() {
    }

    private static String getStringFromPaths(List<String> paths) {
        return String.join((CharSequence)DELIMITER, paths);
    }

    private static List<String> getPathsFromString(String descriptor) {
        return Arrays.asList(descriptor.split(DELIMITER));
    }

    public static String getJsonFromDescriptorMap(Map<Partition, List<String>> descriptorMap) {
        JSONObject out = new JSONObject();
        descriptorMap.forEach((partition, paths) -> {
            String descriptorStr = PartitionDescriptorUtil.getStringFromPaths(paths);
            try {
                out.put(String.valueOf(partition.getPartitionId()), (Object)descriptorStr);
            }
            catch (JSONException e) {
                throw new SamzaException(String.format("Invalid description to encode. partition=%s, descriptor=%s", partition, descriptorStr), (Throwable)e);
            }
        });
        try {
            return out.toString(2);
        }
        catch (JSONException e) {
            throw new SamzaException("Failed to generate json string.", (Throwable)e);
        }
    }

    public static Map<Partition, List<String>> getDescriptorMapFromJson(String json) {
        try {
            Map rawMap = (Map)new ObjectMapper().readValue(json, HashMap.class);
            HashMap<Partition, List<String>> descriptorMap = new HashMap<Partition, List<String>>();
            rawMap.forEach((key, value) -> descriptorMap.put(new Partition(Integer.valueOf(key).intValue()), PartitionDescriptorUtil.getPathsFromString(value)));
            return descriptorMap;
        }
        catch (IOException | NumberFormatException e) {
            throw new SamzaException("Failed to convert json: " + json, (Throwable)e);
        }
    }

    public static Path getPartitionDescriptorPath(String base, String streamName) {
        Path basePath = new Path(base);
        Path relativePath = new Path(streamName.replaceAll("\\W", "_") + "_partition_description");
        return new Path(basePath, relativePath);
    }
}

