/*
 * Decompiled with CFR 0.152.
 */
package org.apache.samza.system.hdfs.descriptors;

import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import org.apache.commons.lang3.StringUtils;
import org.apache.samza.system.descriptors.SystemDescriptor;
import org.apache.samza.system.hdfs.HdfsConfig;
import org.apache.samza.system.hdfs.HdfsSystemFactory;
import org.apache.samza.system.hdfs.descriptors.HdfsInputDescriptor;
import org.apache.samza.system.hdfs.descriptors.HdfsOutputDescriptor;

public class HdfsSystemDescriptor
extends SystemDescriptor<HdfsSystemDescriptor> {
    private static final String FACTORY_CLASS_NAME = HdfsSystemFactory.class.getName();
    private Optional<String> datePathFormat = Optional.empty();
    private Optional<String> outputBaseDir = Optional.empty();
    private Optional<Long> writeBatchSizeBytes = Optional.empty();
    private Optional<Long> writeBatchSizeRecords = Optional.empty();
    private Optional<String> writeCompressionType = Optional.empty();
    private Optional<String> writerClass = Optional.empty();
    private Optional<Long> consumerBufferCapacity = Optional.empty();
    private Optional<Long> consumerMaxRetries = Optional.empty();
    private Optional<String> consumerWhiteList = Optional.empty();
    private Optional<String> consumerBlackList = Optional.empty();
    private Optional<String> consumerGroupPattern = Optional.empty();
    private Optional<String> consumerReader = Optional.empty();
    private Optional<String> consumerStagingDirectory = Optional.empty();

    public HdfsSystemDescriptor(String systemName) {
        super(systemName, FACTORY_CLASS_NAME, null, null);
    }

    public HdfsInputDescriptor getInputDescriptor(String streamId) {
        return new HdfsInputDescriptor(streamId, this);
    }

    public HdfsOutputDescriptor getOutputDescriptor(String streamId) {
        return new HdfsOutputDescriptor(streamId, this);
    }

    public HdfsSystemDescriptor withDatePathFormat(String datePathFormat) {
        this.datePathFormat = Optional.ofNullable(StringUtils.stripToNull((String)datePathFormat));
        return this;
    }

    public HdfsSystemDescriptor withOutputBaseDir(String outputBaseDir) {
        this.outputBaseDir = Optional.ofNullable(StringUtils.stripToNull((String)outputBaseDir));
        return this;
    }

    public HdfsSystemDescriptor withWriteBatchSizeBytes(long writeBatchSizeBytes) {
        this.writeBatchSizeBytes = Optional.of(writeBatchSizeBytes);
        return this;
    }

    public HdfsSystemDescriptor withWriteBatchSizeRecords(long writeBatchSizeRecords) {
        this.writeBatchSizeRecords = Optional.of(writeBatchSizeRecords);
        return this;
    }

    public HdfsSystemDescriptor withWriteCompressionType(String writeCompressionType) {
        this.writeCompressionType = Optional.ofNullable(StringUtils.stripToNull((String)writeCompressionType));
        return this;
    }

    public HdfsSystemDescriptor withWriterClassName(String writerClassName) {
        this.writerClass = Optional.ofNullable(StringUtils.stripToNull((String)writerClassName));
        return this;
    }

    public HdfsSystemDescriptor withConsumerBufferCapacity(long bufferCapacity) {
        this.consumerBufferCapacity = Optional.of(bufferCapacity);
        return this;
    }

    public HdfsSystemDescriptor withConsumerNumMaxRetries(long maxRetries) {
        this.consumerMaxRetries = Optional.of(maxRetries);
        return this;
    }

    public HdfsSystemDescriptor withConsumerWhiteList(String whiteList) {
        this.consumerWhiteList = Optional.ofNullable(StringUtils.stripToNull((String)whiteList));
        return this;
    }

    public HdfsSystemDescriptor withConsumerBlackList(String blackList) {
        this.consumerBlackList = Optional.ofNullable(StringUtils.stripToNull((String)blackList));
        return this;
    }

    public HdfsSystemDescriptor withConsumerGroupPattern(String groupPattern) {
        this.consumerGroupPattern = Optional.ofNullable(StringUtils.stripToNull((String)groupPattern));
        return this;
    }

    public HdfsSystemDescriptor withReaderType(String readerType) {
        this.consumerReader = Optional.ofNullable(StringUtils.stripToNull((String)readerType));
        return this;
    }

    public HdfsSystemDescriptor withStagingDirectory(String stagingDirectory) {
        this.consumerStagingDirectory = Optional.ofNullable(StringUtils.stripToNull((String)stagingDirectory));
        return this;
    }

    public Map<String, String> toConfig() {
        HashMap<String, String> config = new HashMap<String, String>(super.toConfig());
        String systemName = this.getSystemName();
        this.datePathFormat.ifPresent(val -> config.put(String.format(HdfsConfig.DATE_PATH_FORMAT_STRING(), systemName), (String)val));
        this.outputBaseDir.ifPresent(val -> config.put(String.format(HdfsConfig.BASE_OUTPUT_DIR(), systemName), (String)val));
        this.writeBatchSizeBytes.ifPresent(val -> config.put(String.format(HdfsConfig.WRITE_BATCH_SIZE_BYTES(), systemName), String.valueOf(val)));
        this.writeBatchSizeRecords.ifPresent(val -> config.put(String.format(HdfsConfig.WRITE_BATCH_SIZE_RECORDS(), systemName), String.valueOf(val)));
        this.writeCompressionType.ifPresent(val -> config.put(String.format(HdfsConfig.COMPRESSION_TYPE(), systemName), (String)val));
        this.writerClass.ifPresent(val -> config.put(String.format(HdfsConfig.HDFS_WRITER_CLASS_NAME(), systemName), (String)val));
        this.consumerBufferCapacity.ifPresent(val -> config.put(String.format(HdfsConfig.CONSUMER_BUFFER_CAPACITY(), systemName), String.valueOf(val)));
        this.consumerMaxRetries.ifPresent(val -> config.put(String.format(HdfsConfig.CONSUMER_NUM_MAX_RETRIES(), systemName), String.valueOf(val)));
        this.consumerWhiteList.ifPresent(val -> config.put(String.format(HdfsConfig.CONSUMER_PARTITIONER_WHITELIST(), systemName), (String)val));
        this.consumerBlackList.ifPresent(val -> config.put(String.format(HdfsConfig.CONSUMER_PARTITIONER_BLACKLIST(), systemName), (String)val));
        this.consumerGroupPattern.ifPresent(val -> config.put(String.format(HdfsConfig.CONSUMER_PARTITIONER_GROUP_PATTERN(), systemName), (String)val));
        this.consumerReader.ifPresent(val -> config.put(String.format(HdfsConfig.FILE_READER_TYPE(), systemName), (String)val));
        this.consumerStagingDirectory.ifPresent(val -> config.put(String.format(HdfsConfig.STAGING_DIRECTORY(), systemName), (String)val));
        return config;
    }
}

