/*
 * Decompiled with CFR 0.152.
 */
package org.apache.samza.system.hdfs.partitioner;

import java.util.ArrayList;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.annotation.Nullable;
import org.apache.commons.collections.MapUtils;
import org.apache.commons.lang.StringUtils;
import org.apache.samza.Partition;
import org.apache.samza.SamzaException;
import org.apache.samza.system.SystemStreamMetadata;
import org.apache.samza.system.hdfs.partitioner.FileSystemAdapter;
import org.apache.samza.system.hdfs.reader.MultiFileHdfsReader;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DirectoryPartitioner {
    private static final Logger LOG = LoggerFactory.getLogger(DirectoryPartitioner.class);
    private static final String GROUP_IDENTIFIER = "\\[id]";
    private final String whiteListRegex;
    private final String blackListRegex;
    private final String groupPattern;
    private final FileSystemAdapter fileSystemAdapter;
    private final Map<String, Map<Partition, List<String>>> partitionDescriptorMap = new HashMap<String, Map<Partition, List<String>>>();

    public DirectoryPartitioner(String whiteList, String blackList, String groupPattern, FileSystemAdapter fileSystemAdapter) {
        this.whiteListRegex = whiteList;
        this.blackListRegex = blackList;
        this.groupPattern = groupPattern;
        this.fileSystemAdapter = fileSystemAdapter;
        LOG.info(String.format("Creating DirectoryPartitioner with whiteList=%s, blackList=%s, groupPattern=%s", whiteList, blackList, groupPattern));
    }

    private List<FileSystemAdapter.FileMetadata> getFilteredFiles(String streamName) {
        ArrayList<FileSystemAdapter.FileMetadata> filteredFiles = new ArrayList<FileSystemAdapter.FileMetadata>();
        List<FileSystemAdapter.FileMetadata> allFiles = this.fileSystemAdapter.getAllFiles(streamName);
        LOG.info(String.format("List of all files for %s: %s", streamName, allFiles));
        allFiles.stream().filter(file -> file.getPath().matches(this.whiteListRegex) && !file.getPath().matches(this.blackListRegex)).forEach(filteredFiles::add);
        filteredFiles.sort(Comparator.comparing(FileSystemAdapter.FileMetadata::getPath));
        LOG.info(String.format("List of filtered files for %s: %s", streamName, filteredFiles));
        return filteredFiles;
    }

    private String extractGroupIdentifier(String input) {
        if (StringUtils.isBlank((String)GROUP_IDENTIFIER)) {
            return input;
        }
        String[] patterns = this.groupPattern.split(GROUP_IDENTIFIER);
        if (patterns.length != 2) {
            return input;
        }
        Pattern p1 = Pattern.compile(patterns[0]);
        Pattern p2 = Pattern.compile(patterns[1]);
        Matcher m1 = p1.matcher(input);
        Matcher m2 = p2.matcher(input);
        if (!m1.find()) {
            return input;
        }
        int s1 = m1.end();
        if (!m2.find(s1)) {
            return input;
        }
        int s2 = m2.start();
        return input.substring(s1, s2);
    }

    private List<List<FileSystemAdapter.FileMetadata>> generatePartitionGroups(List<FileSystemAdapter.FileMetadata> filteredFiles) {
        HashMap map = new HashMap();
        for (FileSystemAdapter.FileMetadata fileMetadata : filteredFiles) {
            String groupId = this.extractGroupIdentifier(fileMetadata.getPath());
            map.putIfAbsent(groupId, new ArrayList());
            ((List)map.get(groupId)).add(fileMetadata);
        }
        ArrayList<List<FileSystemAdapter.FileMetadata>> ret = new ArrayList<List<FileSystemAdapter.FileMetadata>>();
        ArrayList sortedKeys = new ArrayList(map.keySet());
        sortedKeys.sort(Comparator.naturalOrder());
        sortedKeys.stream().forEach(key -> ret.add((List<FileSystemAdapter.FileMetadata>)map.get(key)));
        return ret;
    }

    private List<FileSystemAdapter.FileMetadata> validateAndGetOriginalFilteredFiles(List<FileSystemAdapter.FileMetadata> newFileList, Map<Partition, List<String>> existingPartitionDescriptor) {
        assert (newFileList != null);
        assert (existingPartitionDescriptor != null);
        HashSet oldFileSet = new HashSet();
        existingPartitionDescriptor.values().forEach(oldFileSet::addAll);
        HashSet newFileSet = new HashSet();
        newFileList.forEach(file -> newFileSet.add(file.getPath()));
        if (!newFileSet.containsAll(oldFileSet)) {
            throw new SamzaException("The list of new files is not a super set of the old files. diff = " + oldFileSet.removeAll(newFileSet));
        }
        newFileList.removeIf(file -> !oldFileSet.contains(file.getPath()));
        return newFileList;
    }

    public Map<Partition, SystemStreamMetadata.SystemStreamPartitionMetadata> getPartitionMetadataMap(String streamName, @Nullable Map<Partition, List<String>> existingPartitionDescriptorMap) {
        LOG.info("Trying to obtain metadata for " + streamName);
        LOG.info("Existing partition descriptor: " + (MapUtils.isEmpty(existingPartitionDescriptorMap) ? "empty" : existingPartitionDescriptorMap));
        HashMap<Partition, SystemStreamMetadata.SystemStreamPartitionMetadata> partitionMetadataMap = new HashMap<Partition, SystemStreamMetadata.SystemStreamPartitionMetadata>();
        this.partitionDescriptorMap.putIfAbsent(streamName, new HashMap());
        List<FileSystemAdapter.FileMetadata> filteredFiles = this.getFilteredFiles(streamName);
        if (!MapUtils.isEmpty(existingPartitionDescriptorMap)) {
            filteredFiles = this.validateAndGetOriginalFilteredFiles(filteredFiles, existingPartitionDescriptorMap);
        }
        List<List<FileSystemAdapter.FileMetadata>> groupedPartitions = this.generatePartitionGroups(filteredFiles);
        int partitionId = 0;
        for (List<FileSystemAdapter.FileMetadata> fileGroup : groupedPartitions) {
            Partition partition = new Partition(partitionId);
            ArrayList pathList = new ArrayList();
            ArrayList lengthList = new ArrayList();
            fileGroup.forEach(fileMetadata -> {
                pathList.add(fileMetadata.getPath());
                lengthList.add(String.valueOf(fileMetadata.getLen()));
            });
            String oldestOffset = MultiFileHdfsReader.generateOffset(0, "0");
            String newestOffset = MultiFileHdfsReader.generateOffset(lengthList.size() - 1, String.valueOf(lengthList.get(lengthList.size() - 1)));
            SystemStreamMetadata.SystemStreamPartitionMetadata metadata = new SystemStreamMetadata.SystemStreamPartitionMetadata(oldestOffset, newestOffset, null);
            partitionMetadataMap.put(partition, metadata);
            this.partitionDescriptorMap.get(streamName).put(partition, pathList);
            ++partitionId;
        }
        LOG.info("Obtained metadata map as: " + partitionMetadataMap);
        LOG.info("Computed partition description as: " + this.partitionDescriptorMap);
        return partitionMetadataMap;
    }

    public Map<Partition, List<String>> getPartitionDescriptor(String streamName) {
        return this.partitionDescriptorMap.get(streamName);
    }
}

