/*
 * Decompiled with CFR 0.152.
 */
package org.apache.samza.system.hdfs.partitioner;

import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileStatus;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.samza.SamzaException;
import org.apache.samza.system.hdfs.partitioner.FileSystemAdapter;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class HdfsFileSystemAdapter
implements FileSystemAdapter {
    private static final Logger LOG = LoggerFactory.getLogger(HdfsFileSystemAdapter.class);

    @Override
    public List<FileSystemAdapter.FileMetadata> getAllFiles(String streamName) {
        ArrayList<FileSystemAdapter.FileMetadata> ret = new ArrayList<FileSystemAdapter.FileMetadata>();
        try {
            FileStatus[] fileStatuses;
            Path streamPath = new Path(streamName);
            FileSystem fileSystem = streamPath.getFileSystem(new Configuration());
            for (FileStatus fileStatus : fileStatuses = fileSystem.listStatus(streamPath)) {
                if (!fileStatus.isDirectory()) {
                    ret.add(new FileSystemAdapter.FileMetadata(fileStatus.getPath().toString(), fileStatus.getLen()));
                    continue;
                }
                ret.addAll(this.getAllFiles(fileStatus.getPath().toString()));
            }
        }
        catch (IOException e) {
            LOG.error("Failed to get the list of files for " + streamName, (Throwable)e);
            throw new SamzaException((Throwable)e);
        }
        return ret;
    }
}

